/*
 * Decompiled with CFR 0.152.
 */
package random;

import java.io.Serializable;
import java.util.Random;
import random.ToxRandom;
import toxgene.ToXgene;

public class ToxGeometric
implements ToxRandom,
Serializable {
    private float min;
    private float max;
    private float p;
    private Random rand;

    public ToxGeometric(float f, float f2, float f3) {
        this.min = f;
        this.max = f2;
        this.p = 1.0f - (f2 - f / f3 + (f2 - f));
        if (f2 < f) {
            System.out.println("***** ERROR: invalid min and max values for ToxGeometric random generator!");
            System.exit(1);
        }
        if (f3 < f || f3 > f2) {
            System.out.println("***** ERROR: invalid mean value for ToxGeometric random generator!");
            System.exit(1);
        }
        this.rand = new Random(ToXgene.seedGenerator.nextLong());
    }

    public long nextInt() {
        return Math.round((double)this.nextFloat());
    }

    public float nextFloat() {
        float f = this.rand.nextFloat();
        float f2 = (float)(Math.log(f) / Math.log(this.p));
        if (f2 < this.min) {
            f2 = this.min;
        }
        if (f2 > this.max) {
            f2 = this.max;
        }
        return f2;
    }

    public float minValue() {
        return this.min;
    }

    public float maxValue() {
        return this.max;
    }

    public long nextInt(float f) {
        if (f < this.min) {
            System.out.println("***** ERROR: cannot update distribution max value: " + f + " is smaller than minimum value: " + this.min);
            System.exit(1);
        }
        return Math.round((double)this.min + (double)((f - this.min) * this.rand.nextFloat()));
    }

    public void resetRandomGen() {
        this.rand.setSeed(ToXgene.seedGenerator.nextLong());
    }
}

