/*
 * Decompiled with CFR 0.152.
 */
package random;

import java.io.Serializable;
import java.util.Random;
import random.ToxRandom;
import toxgene.ToXgene;

public class ToxExponential
implements ToxRandom,
Serializable {
    private float min;
    private float max;
    private float B;
    private double U;
    private Random rand;

    public ToxExponential(float f, float f2, float f3) {
        this.min = f;
        this.max = f2;
        this.B = f3;
        if (f2 < f) {
            System.out.println("***** ERROR: invalid min and max values for ToxExponential random generator!");
            System.exit(1);
        }
        if (f3 < f || f3 > f2) {
            System.out.println("***** ERROR: invalid mean value for ToxExponential random generator!");
            System.exit(1);
        }
        this.rand = new Random(ToXgene.seedGenerator.nextLong());
    }

    public long nextInt() {
        return Math.round(this.nextDouble());
    }

    private double nextDouble() {
        this.U = 1.0 - this.rand.nextDouble();
        double d = (double)(-this.B) * Math.log(this.U);
        if (d < (double)this.min) {
            return this.min;
        }
        if (d > (double)this.max) {
            return this.max;
        }
        return d;
    }

    public float nextFloat() {
        float f = (float)this.nextDouble();
        if (f < this.min) {
            f = this.min;
        }
        if (f > this.max) {
            f = this.max;
        }
        return f;
    }

    public float minValue() {
        return this.min;
    }

    public float maxValue() {
        return this.max;
    }

    public long nextInt(float f) {
        if (f < this.min) {
            System.out.println("***** ERROR: cannot update distribution max value: " + f + " is smaller than minimum value: " + this.min);
            System.exit(1);
        }
        return Math.round((double)this.min + (double)(f - this.min) * this.rand.nextDouble());
    }

    public void resetRandomGen() {
        this.rand.setSeed(ToXgene.seedGenerator.nextLong());
    }
}

