/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import toxgene.ToXgene;

public class ToxValidatingParser
implements ErrorHandler {
    private Document document;
    private String uri;
    DOMParser parser = new DOMParser();

    public ToxValidatingParser(boolean bl) {
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", bl);
        }
        catch (SAXException sAXException) {
            System.out.println("error in setting up parser feature");
        }
        this.parser.setErrorHandler((ErrorHandler)this);
    }

    public Document parse(String string, boolean bl) throws Exception {
        this.uri = string;
        this.parser.parse(string);
        this.document = this.parser.getDocument();
        if (bl) {
            this.trimDOMTree(this.document);
        }
        return this.document;
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.parser.setFeature(string, bl);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        throw sAXParseException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        throw sAXParseException;
    }

    public String findElement(Node node) {
        try {
            int n = 1 + this.countChildrenBefore(node);
            int n2 = 0;
            int n3 = 1;
            FileReader fileReader = new FileReader(this.uri);
            int n4 = fileReader.read();
            while (n4 != -1) {
                if (n4 == 60 && (n4 = fileReader.read()) != 63 && n4 != 91 && n4 != 47 && n4 != 33 && ++n2 == n) {
                    fileReader.close();
                    return "line " + n3;
                }
                if (n4 == 10) {
                    ++n3;
                }
                n4 = fileReader.read();
            }
            fileReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return "?";
        }
        catch (IOException iOException) {
            ToXgene.error("IO exception while attempting to open " + this.uri);
        }
        return "?";
    }

    private int countChildren(Node node) {
        int n = 0;
        Node node2 = null;
        Node node3 = node.getFirstChild();
        while (node3 != null) {
            if (node3.getNodeType() == 1) {
                n += 1 + this.countChildren(node3);
            }
            node3 = node2 = node3.getNextSibling();
        }
        return n;
    }

    private int countChildrenBefore(Node node) {
        int n = 1;
        Node node2 = node.getParentNode();
        Node node3 = null;
        Node node4 = node2.getFirstChild();
        while (node4 != null && node4 != node) {
            node3 = node4.getNextSibling();
            if (node4.getNodeType() == 1) {
                n += 1 + this.countChildren(node4);
            }
            node4 = node3;
        }
        if (node2 != this.document.getDocumentElement()) {
            n += this.countChildrenBefore(node2);
        }
        return n;
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }

    private void trimDOMTree(Node node) {
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                this.trimDOMTree(((Document)node).getDocumentElement());
                break;
            }
            case 1: {
                Node node2 = null;
                Node node3 = node.getFirstChild();
                while (node3 != null) {
                    node2 = node3.getNextSibling();
                    if (node3.getNodeType() == 3) {
                        if (node.getNodeName().compareTo("tox-value") != 0) {
                            node.removeChild(node3);
                        }
                    } else if (node3.getNodeType() == 8) {
                        node.removeChild(node3);
                    } else {
                        this.trimDOMTree(node3);
                    }
                    node3 = node2;
                }
                break;
            }
        }
    }

    public static void printDOMTree(Node node) {
        ToxValidatingParser.printDOMTree(node, 0);
    }

    private static void printDOMTree(Node node, int n) {
        short s = node.getNodeType();
        String string = new String();
        int n2 = 0;
        while (n2 < n) {
            string = string + "  ";
            ++n2;
        }
        System.out.print("(" + s + ") ");
        switch (s) {
            case 9: {
                System.out.print("#DOCUMENT " + node.getNodeName() + " {" + node.getChildNodes().getLength() + "} ");
                int n3 = 0;
                while (n3 < node.getChildNodes().getLength()) {
                    System.out.print("[" + node.getChildNodes().item(n3).getNodeName() + "]");
                    ++n3;
                }
                System.out.println();
                ToxValidatingParser.printDOMTree(((Document)node).getDocumentElement(), n + 1);
                break;
            }
            case 1: {
                System.out.print(string + "#ELEMENT <" + node.getNodeName() + ">{" + node.getChildNodes().getLength() + "} ");
                int n4 = 0;
                while (n4 < node.getChildNodes().getLength()) {
                    System.out.print("[" + node.getChildNodes().item(n4).getNodeName() + "]");
                    ++n4;
                }
                System.out.println();
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n5 = nodeList.getLength();
                int n6 = 0;
                while (n6 < n5) {
                    ToxValidatingParser.printDOMTree(nodeList.item(n6), n + 1);
                    ++n6;
                }
                break;
            }
            case 5: {
                System.out.print(string + "&");
                System.out.print(node.getNodeName());
                System.out.print(";");
                break;
            }
            case 4: {
                System.out.print(string + "<![CDATA[");
                System.out.print(node.getNodeValue());
                System.out.print("]]>");
                break;
            }
            case 3: {
                System.out.print(string + "#TEXT{" + node.getChildNodes().getLength() + "} ");
                if (node.getNodeValue().trim().length() > 0) {
                    System.out.print(node.getNodeValue());
                }
                System.out.println();
                break;
            }
            case 7: {
                System.out.print(string + "<?");
                System.out.print(node.getNodeName());
                String string2 = node.getNodeValue();
                if (string2 != null && string2.length() > 0) {
                    System.out.print(" ");
                    System.out.print(string2);
                }
                System.out.print("?>");
            }
        }
    }
}

