/*
 * Decompiled with CFR 0.152.
 */
package parser;

import factories.CreateGeneException;
import factories.DateFactory;
import factories.IntegerFactory;
import factories.RealFactory;
import factories.SimpleTypeFactory;
import factories.StringFactory;
import genes.ContainerGene;
import genes.Gene;
import genes.lists.ListGene;
import genes.lists.ToxList;
import genes.literals.LiteralGene;
import genes.literals.ToxGet;
import genes.trees.ExpressionParser;
import genes.trees.ToxAlternatives;
import genes.trees.ToxAttribute;
import genes.trees.ToxElement;
import genes.trees.ToxFile;
import genes.trees.ToxIf;
import genes.trees.ToxOption;
import genes.trees.ToxRecursiveElement;
import genes.trees.ToxRecursiveMixedContent;
import genes.trees.ToxScan;
import genes.trees.TreeGene;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import parser.ToxComplexType;
import parser.ToxValidatingParser;
import random.ToxConstant;
import random.ToxExponential;
import random.ToxGaussian;
import random.ToxGeometric;
import random.ToxLogNormal;
import random.ToxRandom;
import random.ToxUniform;
import random.ToxUserDefined;
import toxgene.ToXgene;
import util.Dictionary;
import util.DuplicateKeyException;
import util.KeyNotFoundException;

public class ToxParser {
    private Document doc;
    private Dictionary simpleTypes;
    private Dictionary complexTypes;
    private Dictionary toxLists;
    private Dictionary toxFiles;
    private Dictionary randomGenerators;
    private Dictionary simpleTypeFactories;
    private Vector recChildren;
    private ToxValidatingParser parser;

    public void parse(String string) {
        Document document = null;
        try {
            this.parser = new ToxValidatingParser(true);
            document = this.parser.parse(string, true);
        }
        catch (Exception exception) {
            System.err.println(string + " could not be parsed: \n" + exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
        if (ToXgene.verbose) {
            System.out.println(string + " parsed without problems.\n");
        }
        this.simpleTypeFactories = new Dictionary();
        try {
            this.simpleTypeFactories.add("string", new StringFactory());
            this.simpleTypeFactories.add("integer", new IntegerFactory(1007));
            this.simpleTypeFactories.add("long", new IntegerFactory(1014));
            this.simpleTypeFactories.add("unsignedLong", new IntegerFactory(1015));
            this.simpleTypeFactories.add("int", new IntegerFactory(1012));
            this.simpleTypeFactories.add("unsignedInt", new IntegerFactory(1013));
            this.simpleTypeFactories.add("short", new IntegerFactory(1016));
            this.simpleTypeFactories.add("unsignedShort", new IntegerFactory(1016));
            this.simpleTypeFactories.add("byte", new IntegerFactory(1004));
            this.simpleTypeFactories.add("nonNegativeInteger", new IntegerFactory(1010));
            this.simpleTypeFactories.add("positiveInteger", new IntegerFactory(1008));
            this.simpleTypeFactories.add("nonPositiveInteger", new IntegerFactory(1011));
            this.simpleTypeFactories.add("negativeInteger", new IntegerFactory(1009));
            this.simpleTypeFactories.add("decimal", new RealFactory(1018));
            this.simpleTypeFactories.add("float", new RealFactory(1019));
            this.simpleTypeFactories.add("double", new RealFactory(1020));
            this.simpleTypeFactories.add("date", new DateFactory());
            this.simpleTypeFactories.add("number", new RealFactory(1019));
        }
        catch (DuplicateKeyException duplicateKeyException) {
            // empty catch block
        }
        this.simpleTypes = ToXgene.simpleTypes;
        this.complexTypes = new Dictionary();
        this.toxLists = ToXgene.toxLists;
        this.toxFiles = new Dictionary();
        ToXgene.randomGenerators = this.randomGenerators = new Dictionary();
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            String string2 = node.getNodeName();
            if (string2.compareTo("tox-distribution") == 0) {
                this.processDistribution(node);
            } else if (string2.compareTo("simpleType") == 0) {
                this.processSimpleType(node);
            } else if (string2.compareTo("complexType") == 0) {
                this.processComplexType(node);
            } else if (string2.compareTo("tox-list") == 0) {
                this.processToxList(node);
            } else if (string2.compareTo("tox-document") == 0) {
                this.processToxFile(node);
            }
            ++n;
        }
        if (ToXgene.verbose) {
            System.out.println("DONE processing template file.");
        }
    }

    public String findElement(Node node) {
        return this.parser.findElement(node);
    }

    public Vector documents() {
        return this.toxFiles.values();
    }

    public Vector lists() {
        return this.toxLists.values();
    }

    public void deleteList(String string) {
        try {
            this.toxLists.remove(string);
        }
        catch (KeyNotFoundException keyNotFoundException) {
            ToXgene.error("DIED A REALLY HORRIBLE DEATH");
        }
    }

    private void processSimpleType(Node node) {
        Gene gene = null;
        String string = "";
        try {
            string = ((Element)node).getAttributeNode("name").getNodeValue();
        }
        catch (NullPointerException nullPointerException) {
            ToXgene.error("\"name\" attribute required for simpleType.", node);
        }
        if (this.simpleTypes.contains(string)) {
            ToXgene.error("simpleType \"" + string + "\" already declared!", node);
        }
        Node node2 = ((Element)node).getFirstChild();
        ToXgene.explain("Processing SimpleType: " + string);
        if (((Element)node2).getElementsByTagName("tox-expr").getLength() != 0) {
            Node node3 = node2.getFirstChild();
            String string2 = node3.getNodeName();
            if (string2.compareTo("tox-scan") != 0 && string2.compareTo("tox-sample") != 0 && string2.compareTo("tox-foreach") != 0) {
                ToXgene.error("invalid simpleType declaration", node);
            }
            gene = this.createToxScanGene(node3, null, true, null, 1, 1);
        } else {
            gene = this.createSimpleTypeGene(node2);
        }
        try {
            this.simpleTypes.add(string, gene);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            // empty catch block
        }
        ToXgene.explain(" -----> done!");
    }

    private void processComplexType(Node node) {
        String string;
        String string2 = ((Element)node).getAttributeNode("name").getNodeValue();
        if (ToXgene.verbose) {
            System.out.println("Processing ComplexType: " + string2);
        }
        ToxComplexType toxComplexType = (string = ((Element)node).getAttributeNode("mixed").getNodeValue()).compareTo("true") == 0 ? this.createComplexType(node.getChildNodes(), null, null, true, 0, 0) : this.createComplexType(node.getChildNodes(), null, null, false, 0, 0);
        try {
            this.complexTypes.add(string2, toxComplexType);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            ToXgene.error("duplicate type declaration: " + string2, node);
        }
        if (ToXgene.verbose) {
            System.out.println("-----> done ComplexType: " + string2);
        }
    }

    private void processToxList(Node node) {
        Object object;
        ToxList toxList = null;
        String string = ((Element)node).getAttributeNode("name").getNodeValue();
        ToXgene.explain("Processing tox-list: " + string);
        String string2 = "";
        try {
            string2 = ((Element)node).getAttributeNode("unique").getNodeValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String string3 = "";
        try {
            string3 = ((Element)node).getAttributeNode("where").getNodeValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String string4 = ((Element)node).getAttributeNode("dump").getNodeValue();
        Node node2 = node.getFirstChild();
        ToxElement toxElement = (ToxElement)this.createToxElementGene(node2, null, null);
        try {
            object = ((Element)node).getAttributeNode("readFrom").getNodeValue();
            String string5 = ((Element)node).getAttributeNode("abort").getNodeValue();
            toxList = new ToxList(string, toxElement, string2, string3, string4.compareTo("yes") == 0, (String)object, string5.compareTo("yes") == 0, node);
        }
        catch (NullPointerException nullPointerException) {
            toxList = new ToxList(string, toxElement, string2, string3, string4.compareTo("yes") == 0, node);
        }
        try {
            this.toxLists.add(string, toxList);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            ToXgene.error("duplicate tox-list declaration: " + duplicateKeyException.getMessage(), node);
        }
        object = this.getListReferences(toxElement);
        if (object != null) {
            toxList.references((Vector)object);
        }
        ToXgene.explain("-----> done tox-list: " + string);
    }

    private void processToxFile(Node node) {
        Object object;
        boolean bl;
        ToxFile toxFile = null;
        int n = 0;
        int n2 = 0;
        String string = ((Element)node).getAttributeNode("name").getNodeValue();
        try {
            n = Integer.parseInt(((Element)node).getAttributeNode("copies").getNodeValue());
        }
        catch (NumberFormatException numberFormatException) {
            ToXgene.error("invalid number of copies for file " + string, node);
        }
        if (n < 1) {
            ToXgene.warning("number of copies is smaller than 1!\n\tdefining copies = 1");
            n = 1;
        }
        ToXgene.explain("Processing document: " + string);
        Node node2 = ((Element)node).getFirstChild();
        ToxElement toxElement = (ToxElement)this.createToxElementGene(node2, null, null);
        try {
            n2 = Integer.parseInt(((Element)node).getAttributeNode("starting-number").getNodeValue());
        }
        catch (NumberFormatException numberFormatException) {
            ToXgene.error("invalid starting number for tox-document:" + string, node);
        }
        catch (NullPointerException nullPointerException) {
            n2 = 0;
        }
        if (n2 < 0) {
            ToXgene.warning("starting-number is negative! \n\tdefining starting-number = 0");
            n2 = 0;
        }
        try {
            bl = ((Element)node).getAttributeNode("pad").getNodeValue().compareTo("yes") == 0;
        }
        catch (NullPointerException nullPointerException) {
            ToXgene.warning("It seems you are using an outdated DTD for ToXgene templates. Please download the latest one.");
            bl = false;
        }
        try {
            object = ((Element)node).getAttributeNode("DTD-file").getNodeValue();
            toxFile = new ToxFile(string, n, n2, (String)object, toxElement, bl);
        }
        catch (NullPointerException nullPointerException) {
            toxFile = new ToxFile(string, n, n2, toxElement, bl);
        }
        try {
            this.toxFiles.add(string, toxFile);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            ToXgene.error("duplicate document declaration: " + duplicateKeyException.getMessage(), node);
        }
        object = this.getListReferences(toxElement);
        if (object != null) {
            toxFile.references((Vector)object);
        }
        if (ToXgene.verbose) {
            System.out.println("-----> done tox-document: " + string);
        }
    }

    private void processDistribution(Node node) {
        float f;
        float f2;
        ToxRandom toxRandom = null;
        String string = ((Element)node).getAttributeNode("name").getNodeValue();
        String string2 = ((Element)node).getAttributeNode("type").getNodeValue();
        float f3 = new Float(((Element)node).getAttributeNode("minInclusive").getNodeValue()).floatValue();
        float f4 = new Float(((Element)node).getAttributeNode("maxInclusive").getNodeValue()).floatValue();
        if (string2.compareTo("uniform") == 0) {
            toxRandom = new ToxUniform(f3, f4);
        }
        if (string2.compareTo("normal") == 0) {
            try {
                f2 = new Float(((Element)node).getAttributeNode("mean").getNodeValue()).floatValue();
                f = new Float(((Element)node).getAttributeNode("variance").getNodeValue()).floatValue();
                toxRandom = new ToxGaussian(f3, f4, f2, f);
            }
            catch (NullPointerException nullPointerException) {
                ToXgene.error("Invalid gaussian distribution specification!", node);
            }
        }
        if (string2.compareTo("lognormal") == 0) {
            try {
                f2 = new Float(((Element)node).getAttributeNode("mean").getNodeValue()).floatValue();
                f = new Float(((Element)node).getAttributeNode("variance").getNodeValue()).floatValue();
                toxRandom = new ToxLogNormal(f3, f4, f2, f);
            }
            catch (NullPointerException nullPointerException) {
                ToXgene.error("Invalid lognormal distribution specification!", node);
            }
        }
        if (string2.compareTo("exponential") == 0) {
            try {
                float f5 = new Float(((Element)node).getAttributeNode("mean").getNodeValue()).floatValue();
                toxRandom = new ToxExponential(f3, f4, f5);
            }
            catch (NullPointerException nullPointerException) {
                ToXgene.error("Invalid exponential distribution specification!", node);
            }
        }
        if (string2.compareTo("geometric") == 0) {
            try {
                float f6 = new Float(((Element)node).getAttributeNode("mean").getNodeValue()).floatValue();
                toxRandom = new ToxGeometric(f3, f4, f6);
            }
            catch (NullPointerException nullPointerException) {
                ToXgene.error("Invalid geometric distribution specification!", node);
            }
        }
        if (string2.compareTo("constant") == 0) {
            if (f3 != f4) {
                ToXgene.warning("min and max values are not equal forconstant distribution " + string);
            }
            toxRandom = new ToxConstant(f3);
        }
        if (string2.compareTo("user-defined") == 0) {
            toxRandom = new ToxUserDefined(f3, f4);
            NodeList nodeList = node.getChildNodes();
            f = 0.0f;
            int n = 0;
            while (n < nodeList.getLength()) {
                Element element = (Element)nodeList.item(n);
                float f7 = 0.0f;
                float f8 = 0.0f;
                try {
                    f7 = Float.parseFloat(element.getAttributeNode("value").getNodeValue());
                    f8 = Float.parseFloat(element.getAttributeNode("tox-percent").getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    ToXgene.error("could not parse floating point numbers for user defined-distribution" + string, node);
                }
                f += f8;
                if ((double)f > 100.0) {
                    ToXgene.error("probability mass adds to more than 100!", node);
                } else {
                    ((ToxUserDefined)toxRandom).addOption(f7, f8);
                }
                ++n;
            }
        }
        try {
            this.randomGenerators.add(string, toxRandom);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            // empty catch block
        }
    }

    private Vector getListReferences(TreeGene treeGene) {
        Vector<ToxList> vector = null;
        Vector vector2 = treeGene.children();
        int n = vector2 == null ? 0 : vector2.size();
        int n2 = 0;
        while (n2 < n) {
            try {
                Vector vector3;
                TreeGene treeGene2 = (TreeGene)vector2.get(n2);
                if (treeGene2 instanceof ToxScan) {
                    if (vector == null) {
                        vector = new Vector<ToxList>();
                    }
                    vector.add(((ToxScan)treeGene2).list());
                }
                if ((vector3 = this.getListReferences(treeGene2)) != null) {
                    if (vector == null) {
                        vector = new Vector();
                    }
                    vector.addAll(vector3);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++n2;
        }
        return vector;
    }

    private Gene createSimpleTypeGene(Node node) {
        String string = ((Element)node).getAttributeNode("base").getNodeValue();
        try {
            SimpleTypeFactory simpleTypeFactory = (SimpleTypeFactory)this.simpleTypeFactories.get(string);
            try {
                return simpleTypeFactory.createGene(node.getChildNodes());
            }
            catch (CreateGeneException createGeneException) {
                ToXgene.error("invalid simpleType defintion: " + createGeneException.getMessage(), node);
            }
        }
        catch (KeyNotFoundException keyNotFoundException) {
            ToXgene.error("cannot find type \"" + string + "\" definition", node);
        }
        return null;
    }

    private Gene createPrimitiveGene(Node node) throws Exception {
        String string = node.getNodeName();
        String string2 = "string";
        if (string.compareTo("tox-number") == 0) {
            string2 = "float";
        }
        try {
            SimpleTypeFactory simpleTypeFactory = (SimpleTypeFactory)this.simpleTypeFactories.get(string2);
            return simpleTypeFactory.createGene(node);
        }
        catch (KeyNotFoundException keyNotFoundException) {
            return null;
        }
    }

    private ToxComplexType createComplexType(NodeList nodeList, ToxScan toxScan, String string, boolean bl, int n, int n2) {
        ToxComplexType toxComplexType = new ToxComplexType();
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = 0;
        while (n3 < nodeList.getLength()) {
            ListGene listGene;
            Gene gene;
            Node node = nodeList.item(n3);
            String string2 = node.getNodeName();
            if (string2.compareTo("attribute") == 0) {
                gene = this.createToxAttributeGene(node, toxScan);
                toxComplexType.addAttribute(gene);
            } else if (string2.compareTo("element") == 0) {
                if (!bl && bl2) {
                    ToXgene.error("mixed content not allowed for element in complex type declaration!", node);
                }
                gene = this.createToxElementGene(node, toxScan, string);
                toxComplexType.addContent(gene);
                bl3 = true;
            } else if (string2.compareTo("tox-scan") == 0) {
                listGene = this.createToxScanGene(node, toxScan, bl, string, n, n2);
                if (((ToxScan)listGene).hasAttributes()) {
                    toxComplexType.addContainer((ContainerGene)((Object)listGene));
                }
                toxComplexType.addScan((ToxScan)listGene);
            } else if (string2.compareTo("tox-sample") == 0) {
                listGene = this.createToxScanGene(node, toxScan, bl, string, n, n2);
                if (((ToxScan)listGene).hasAttributes()) {
                    toxComplexType.addContainer((ContainerGene)((Object)listGene));
                }
                toxComplexType.addScan((ToxScan)listGene);
            } else if (string2.compareTo("tox-foreach") == 0) {
                listGene = this.createToxScanGene(node, toxScan, bl, string, n, n2);
                if (((ToxScan)listGene).hasAttributes()) {
                    toxComplexType.addContainer((ContainerGene)((Object)listGene));
                }
                toxComplexType.addScan((ToxScan)listGene);
            } else if (string2.compareTo("tox-alternatives") == 0) {
                listGene = this.createToxAlternativesGene(node, toxScan, string, bl, n, n2);
                if (((ToxAlternatives)listGene).hasAttributes()) {
                    toxComplexType.addContainer((ContainerGene)((Object)listGene));
                }
                toxComplexType.addContent((Gene)((Object)listGene));
            } else if (string2.compareTo("tox-if") == 0) {
                listGene = this.createToxIfGene(node, toxScan, string, bl, n, n2);
                if (((ToxIf)listGene).hasAttributes()) {
                    toxComplexType.addContainer((ContainerGene)((Object)listGene));
                }
                toxComplexType.addContent((Gene)((Object)listGene));
            } else if (string2.compareTo("tox-expr") == 0) {
                listGene = this.createToxGetGene(node, toxScan, n, n2);
                toxComplexType.addContent((Gene)((Object)listGene));
                if (((LiteralGene)listGene).getType().compareTo("complex") != 0) {
                    bl2 = true;
                }
            } else {
                try {
                    gene = this.createPrimitiveGene(node);
                    toxComplexType.addContent(gene);
                    bl2 = true;
                }
                catch (Exception exception) {
                    ToXgene.error("invalid type declaration!", node);
                }
            }
            ++n3;
        }
        return toxComplexType;
    }

    private Gene createToxElementGene(Node node, ToxScan toxScan, String string) {
        Object object;
        String string2 = "";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        ToxElement toxElement = null;
        ToxRandom toxRandom = null;
        String string3 = string;
        String string4 = new String(((Element)node).getAttributeNode("name").getNodeValue());
        n3 = Integer.parseInt(((Element)node).getAttributeNode("minOccurs").getNodeValue());
        String string5 = ((Element)node).getAttributeNode("maxOccurs").getNodeValue();
        n4 = string5.compareTo("unbounded") != 0 ? Integer.parseInt(string5) : -1;
        boolean bl = false;
        try {
            String string6 = ((Element)node).getAttributeNode("tox-reset").getNodeValue();
            bl = string6.compareTo("yes") == 0;
        }
        catch (Exception exception) {
            ToXgene.error("it seems your template referencess an outdated DTD.\nSome ToXgene features cannot work properly unless you use the latest DTD.\n");
        }
        boolean bl2 = false;
        try {
            object = ((Element)node).getAttributeNode("tox-omitTag").getNodeValue();
            bl2 = ((String)object).compareTo("yes") == 0;
        }
        catch (Exception exception) {
            ToXgene.error("it seems your template refers to an outdated DTD.\nSome ToXgene features cannot work properly unless you use the latest DTD.\n");
        }
        try {
            string2 = ((Element)node).getAttributeNode("tox-distribution").getNodeValue();
            toxRandom = (ToxRandom)this.randomGenerators.get(string2);
            n = (int)toxRandom.minValue();
            n2 = (int)toxRandom.maxValue();
        }
        catch (NullPointerException nullPointerException) {
            n = n3;
            n2 = n4;
            if (n4 > 0 && n4 < n3) {
                ToXgene.warning("maxOccurs smaller than minOccurs for element: " + string4 + ". Defining maxOccurs = " + n3 + ".");
                n4 = n3;
            }
            if (n2 != -1) {
                toxRandom = n3 == n4 ? new ToxConstant(n3) : new ToxUniform(n3, n4);
            }
        }
        catch (KeyNotFoundException keyNotFoundException) {
            ToXgene.error("undefined tox-distribution " + string2 + " in element\"" + string4 + "\"", node);
        }
        if (n < n3) {
            ToXgene.error("element " + string4 + " cannot occur less than " + n3 + " times!", node);
        }
        if (n4 != -1 && n2 > n4) {
            ToXgene.warning("maxOccurs for element \"" + string4 + "\" is smaller than " + "value defined by maxInclusive in distribution " + string2);
        }
        object = null;
        boolean bl3 = false;
        if (string != null && string4.compareTo(string) == 0) {
            if (this.recChildren == null) {
                this.recChildren = new Vector();
            }
            object = new ToxRecursiveElement(n, n2, toxRandom, string4);
            this.recChildren.add(object);
            bl3 = true;
        }
        boolean bl4 = false;
        ToxRandom toxRandom2 = null;
        String string7 = null;
        try {
            string7 = ((Element)node).getAttributeNode("tox-recursionLevels").getNodeValue();
            toxRandom2 = (ToxRandom)ToXgene.randomGenerators.get(string7);
            if (string3 != null) {
                ToXgene.error("cannot have recursive element: " + string7 + " nested within other recursive element: " + string3, node);
            }
            bl4 = true;
            string3 = string4;
        }
        catch (KeyNotFoundException keyNotFoundException) {
            try {
                int n5 = Integer.parseInt(string7);
                toxRandom2 = new ToxUniform(0.0f, n5);
                bl4 = true;
                string3 = string4;
            }
            catch (NumberFormatException numberFormatException) {
                ToXgene.error("invalid recursive element \"" + string4 + "\":\n cannot find tox-distribution named with or parse" + " an integer from \"" + string7 + "\"", node);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (!node.hasChildNodes()) {
            try {
                String string8 = ((Element)node).getAttributeNode("type").getNodeValue();
                try {
                    Gene gene = (Gene)this.simpleTypes.get(string8);
                    if (bl3) {
                        ((ToxRecursiveElement)object).addBackup(gene);
                        return object;
                    }
                    toxElement = bl2 ? new ToxRecursiveMixedContent(n, n2, toxRandom, true, bl) : new ToxElement(string4, n, n2, toxRandom, true, bl);
                    toxElement.addContent(gene);
                }
                catch (KeyNotFoundException keyNotFoundException) {
                    try {
                        ToxComplexType toxComplexType = (ToxComplexType)this.complexTypes.get(string8);
                        toxElement = bl2 ? new ToxRecursiveMixedContent(n, n2, toxRandom, false, bl) : new ToxElement(string4, n, n2, toxRandom, false, bl);
                        toxElement.addComplexType(toxComplexType);
                    }
                    catch (KeyNotFoundException keyNotFoundException2) {
                        SimpleTypeFactory simpleTypeFactory = (SimpleTypeFactory)this.simpleTypeFactories.get(string8);
                        toxElement = bl2 ? new ToxRecursiveMixedContent(n, n2, toxRandom, true, bl) : new ToxElement(string4, n, n2, toxRandom, true, bl);
                        toxElement.addContent(simpleTypeFactory.createGene());
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                if (bl3) {
                    return object;
                }
                ToXgene.error("no type specified for element \"" + string4 + "\"", node);
            }
            return toxElement;
        }
        Node node2 = node.getFirstChild();
        String string9 = node2.getNodeName();
        if (string9.compareTo("simpleType") == 0) {
            toxElement = bl2 ? new ToxRecursiveMixedContent(n, n2, toxRandom, true, bl) : new ToxElement(string4, n, n2, toxRandom, true, bl);
            ToXgene.explain("Processing anonymous SimpleType in: " + string4);
            Node node3 = node2.getFirstChild();
            if (((Element)node3).getElementsByTagName("tox-expr").getLength() != 0) {
                Node node4 = node3.getFirstChild();
                String string10 = node4.getNodeName();
                if (string10.compareTo("tox-scan") != 0 && string10.compareTo("tox-sample") != 0 && string10.compareTo("tox-foreach") != 0) {
                    ToXgene.error("invalid simpleType declaration", node3);
                }
                ToxScan toxScan2 = this.createToxScanGene(node4, toxScan, true, null, n, n2);
                toxElement.addScan(toxScan2);
            } else {
                toxElement.addContent(this.createSimpleTypeGene(node3));
            }
            ToXgene.explain("-----> done SimpleType in: " + string4);
            return toxElement;
        }
        if (string9.compareTo("complexType") == 0) {
            toxElement = bl2 ? new ToxRecursiveMixedContent(n, n2, toxRandom, false, bl) : new ToxElement(string4, n, n2, toxRandom, false, bl);
            ToXgene.explain("Processing anonymous ComplexType in: " + string4);
            String string11 = ((Element)node2).getAttributeNode("mixed").getNodeValue();
            if (string11.compareTo("true") == 0) {
                toxElement.addComplexType(this.createComplexType(node2.getChildNodes(), toxScan, string3, true, n, n2));
            } else {
                toxElement.addComplexType(this.createComplexType(node2.getChildNodes(), toxScan, string3, false, n, n2));
            }
            ToXgene.explain("-----> done ComplexType in: " + string4);
            if (bl4) {
                try {
                    int n6 = 0;
                    while (n6 < this.recChildren.size()) {
                        ToxRecursiveElement toxRecursiveElement = (ToxRecursiveElement)this.recChildren.get(n6);
                        toxRecursiveElement.setContent(toxElement, toxRandom2, this.recChildren);
                        ++n6;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    ToXgene.warning("no recursive descendant for element: " + string4 + " was found.");
                }
                this.recChildren = null;
            }
            return toxElement;
        }
        if (string9.compareTo("tox-expr") == 0) {
            ToxGet toxGet = this.createToxGetGene(node2, toxScan, n, n2);
            if (bl3) {
                ((ToxRecursiveElement)object).addBackup(toxGet);
                return object;
            }
            toxElement = bl2 ? new ToxRecursiveMixedContent(n, n2, toxRandom, true, bl) : new ToxElement(string4, n, n2, toxRandom, true, bl);
            toxElement.addVarQttyContent(toxGet);
            return toxElement;
        }
        ToXgene.error("invalid element definition:" + string4, node);
        return null;
    }

    private Gene createToxAttributeGene(Node node, ToxScan toxScan) {
        Object object;
        Gene gene = null;
        ToxAttribute toxAttribute = null;
        String string = "";
        String string2 = "";
        char c = '\u0000';
        ToxRandom toxRandom = null;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        String string3 = ((Element)node).getAttributeNode("name").getNodeValue();
        if (ToXgene.verbose) {
            System.out.println("Processing attribute: " + string3);
        }
        try {
            string = ((Element)node).getAttributeNode("tox-distribution").getNodeValue();
            toxRandom = (ToxRandom)this.randomGenerators.get(string);
            n = (int)toxRandom.minValue();
            n2 = (int)toxRandom.maxValue();
        }
        catch (KeyNotFoundException keyNotFoundException) {
            ToXgene.error("Invalid distribution name: " + string, node);
        }
        catch (NullPointerException nullPointerException) {
            String string4 = ((Element)node).getAttributeNode("tox-minOccurs").getNodeValue();
            n = Integer.parseInt(string4);
            string4 = ((Element)node).getAttributeNode("tox-maxOccurs").getNodeValue();
            if (string4.compareTo("unbounded") != 0) {
                n2 = Integer.parseInt(string4);
                toxRandom = new ToxUniform(n, n2);
            }
            n2 = -1;
        }
        try {
            object = ((Element)node).getAttributeNode("tox-distribution").getNodeValue();
            if (((String)object).length() != 1) {
                ToXgene.error("Invalid separator \"" + (String)object + "\" for multivalued " + "attribute!");
            }
            c = ((String)object).charAt(0);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (node.hasChildNodes()) {
            object = node.getFirstChild();
            if (object.getNodeName().compareTo("tox-expr") == 0) {
                gene = this.createToxGetGene((Node)object, toxScan, n, n2);
                bl = true;
            } else if (object.getNodeName().compareTo("simpleType") == 0) {
                Node node2 = object.getFirstChild();
                if (((Element)node2).getElementsByTagName("tox-expr").getLength() != 0) {
                    Node node3 = node2.getFirstChild();
                    String string5 = node3.getNodeName();
                    if (string5.compareTo("tox-scan") != 0 && string5.compareTo("tox-sample") != 0 && string5.compareTo("tox-foreach") != 0) {
                        ToXgene.error("invalid simpleType declaration", node2);
                    }
                    ToxScan toxScan2 = this.createToxScanGene(node3, toxScan, true, null, n, n2);
                    gene = toxScan2;
                    bl = true;
                } else {
                    gene = this.createSimpleTypeGene(node2);
                }
            }
        } else {
            try {
                string2 = ((Element)node).getAttributeNode("type").getNodeValue();
                gene = (Gene)this.simpleTypes.get(string2);
            }
            catch (KeyNotFoundException keyNotFoundException) {
                try {
                    SimpleTypeFactory simpleTypeFactory = (SimpleTypeFactory)this.simpleTypeFactories.get(string2);
                    gene = simpleTypeFactory.createGene(node.getChildNodes());
                }
                catch (KeyNotFoundException keyNotFoundException2) {
                    ToXgene.error("invalid \"" + string3 + "\" attribute declaration: " + keyNotFoundException2.getMessage(), node);
                }
            }
            catch (NullPointerException nullPointerException) {
                ToXgene.error("invalid \"" + string3 + "\" attribute declaration: no type" + " specified", node);
            }
        }
        toxAttribute = new ToxAttribute(string3, n, n2, gene, toxRandom, bl, c);
        if (ToXgene.verbose) {
            System.out.println("-----> done attribute: " + string3);
        }
        return toxAttribute;
    }

    private ToxGet createToxGetGene(Node node, ToxScan toxScan, int n, int n2) {
        ToxGet toxGet = null;
        String string = "";
        String string2 = "";
        try {
            string = ((Element)node).getAttributeNode("value").getNodeValue();
        }
        catch (NullPointerException nullPointerException) {
            ToXgene.error("no query specified for tox-expr item!", node);
        }
        try {
            string2 = ((Element)node).getAttributeNode("format").getNodeValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ToXgene.explain("Processing tox-expr for: " + string);
        toxGet = new ToxGet(ExpressionParser.parse(string, toxScan, node), n, n2, string2);
        return toxGet;
    }

    private ToxAlternatives createToxAlternativesGene(Node node, ToxScan toxScan, String string, boolean bl, int n, int n2) {
        ToxComplexType toxComplexType = null;
        ToxOption toxOption = null;
        ToxRandom toxRandom = null;
        NodeList nodeList = node.getChildNodes();
        ToXgene.explain("Processing tox-alternatives:");
        try {
            String string2 = ((Element)node).getAttributeNode("tox-distribution").getNodeValue();
            toxRandom = (ToxRandom)this.randomGenerators.get(string2);
            int n3 = (int)toxRandom.minValue();
            int n4 = (int)toxRandom.maxValue();
            if (n3 < 0 || n4 > 100) {
                ToXgene.error("the probability distribution for choosing among alternatives has to be in [0,100]", node);
            }
            if (n3 != 0 || n4 != 100) {
                ToXgene.warning("probabiliy distribution != [0,100]!\n\tno action taken");
            }
        }
        catch (KeyNotFoundException keyNotFoundException) {
            ToXgene.error("invalid distribution name: ", node);
        }
        catch (NullPointerException nullPointerException) {
            toxRandom = new ToxUniform(0.0f, 100.0f);
        }
        ToxAlternatives toxAlternatives = new ToxAlternatives(toxRandom);
        int n5 = 0;
        while (n5 < nodeList.getLength()) {
            Node node2 = nodeList.item(n5);
            if (node2.getNodeName().compareTo("tox-option") == 0) {
                Float f = new Float(((Element)node2).getAttributeNode("odds").getNodeValue());
                ToXgene.explain("Processing tox-option; odds = " + f);
                toxOption = new ToxOption();
                toxComplexType = this.createComplexType(node2.getChildNodes(), toxScan, string, bl, n, n2);
                Vector vector = toxComplexType.contents();
                int n6 = 0;
                while (n6 < vector.size()) {
                    toxOption.addElement((Gene)vector.elementAt(n6));
                    ++n6;
                }
                Vector vector2 = toxComplexType.attributes();
                int n7 = 0;
                while (n7 < vector2.size()) {
                    toxOption.addAttribute((Gene)vector2.elementAt(n7));
                    ++n7;
                }
                toxAlternatives.addOption(f.floatValue(), toxOption);
                ToXgene.explain("-----> done tox-option");
            }
            ++n5;
        }
        ToXgene.explain("-----> done tox-alternatives");
        return toxAlternatives;
    }

    private ToxIf createToxIfGene(Node node, ToxScan toxScan, String string, boolean bl, int n, int n2) {
        ToxComplexType toxComplexType = null;
        ToxOption toxOption = null;
        ToxOption toxOption2 = null;
        NodeList nodeList = node.getChildNodes();
        ToXgene.explain("Processing tox-if:");
        if (toxScan == null) {
            ToXgene.error("tox-if declared out of tox-scan/tox-sample/tox-foreach scope!", node);
        }
        String string2 = ((Element)node).getAttributeNode("expr").getNodeValue();
        Node node2 = nodeList.item(0);
        ToXgene.explain("Processing tox-then clause");
        toxOption = new ToxOption();
        toxComplexType = this.createComplexType(node2.getChildNodes(), toxScan, string, bl, n, n2);
        Vector vector = toxComplexType.contents();
        int n3 = 0;
        while (n3 < vector.size()) {
            toxOption.addElement((Gene)vector.elementAt(n3));
            ++n3;
        }
        vector = toxComplexType.attributes();
        int n4 = 0;
        while (n4 < vector.size()) {
            toxOption.addAttribute((Gene)vector.elementAt(n4));
            ++n4;
        }
        if (ToXgene.verbose) {
            System.out.println("-----> done tox-then");
        }
        ToxIf toxIf = new ToxIf(string2, toxScan, toxOption, node);
        if (nodeList.getLength() == 2) {
            node2 = nodeList.item(1);
            ToXgene.explain("Processing tox-else clause");
            toxOption2 = new ToxOption();
            toxComplexType = this.createComplexType(node2.getChildNodes(), toxScan, string, bl, n, n2);
            vector = toxComplexType.contents();
            int n5 = 0;
            while (n5 < vector.size()) {
                toxOption2.addElement((Gene)vector.elementAt(n5));
                ++n5;
            }
            vector = toxComplexType.attributes();
            int n6 = 0;
            while (n6 < vector.size()) {
                toxOption2.addAttribute((Gene)vector.elementAt(n6));
                ++n6;
            }
            ToXgene.explain("-----> done tox-else");
            toxIf.addElseBlock(toxOption2);
        }
        ToXgene.explain("-----> done tox-if");
        return toxIf;
    }

    private ToxScan createToxScanGene(Node node, ToxScan toxScan, boolean bl, String string, int n, int n2) {
        Object object;
        boolean bl2 = node.getNodeName().compareTo("tox-sample") == 0;
        boolean bl3 = node.getNodeName().compareTo("tox-foreach") == 0;
        ToxRandom toxRandom = null;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        string2 = ((Element)node).getAttributeNode("path").getNodeValue();
        if (bl2) {
            ToXgene.explain("Processing tox-sample: ");
        } else if (bl3) {
            ToXgene.explain("Processing tox-foreach: ");
        } else {
            ToXgene.explain("Processing tox-scan: ");
        }
        try {
            string4 = ((Element)node).getAttributeNode("name").getNodeValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            string5 = ((Element)node).getAttributeNode("where").getNodeValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (bl2) {
            string3 = ((Element)node).getAttributeNode("duplicates").getNodeValue();
            try {
                object = ((Element)node).getAttributeNode("tox-distribution").getNodeValue();
                toxRandom = (ToxRandom)this.randomGenerators.get((String)object);
                if (toxRandom.minValue() != 0.0f) {
                    ToXgene.warning("minimum value in distribution " + (String)object + " != 0.\n Some elements in " + string2 + " might never be accessed!");
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (bl2) {
            ToXgene.explain("path: " + string2 + " duplicates: " + string3);
        } else {
            ToXgene.explain("path: " + string2);
        }
        ToxScan toxScan2 = new ToxScan(string2, toxScan, string4, bl3, bl2, string3.compareTo("yes") == 0, toxRandom, string5, node);
        object = node.getChildNodes();
        ToxComplexType toxComplexType = this.createComplexType((NodeList)object, toxScan2, string, bl, n, n2);
        toxScan2.addComplexType(toxComplexType);
        return toxScan2;
    }
}

