/*
 * Decompiled with CFR 0.152.
 */
package parser;

import genes.ContainerGene;
import genes.Gene;
import genes.VarQttyGene;
import genes.trees.ToxScan;
import java.util.Vector;

public class ToxComplexType {
    private Vector attributes = new Vector();
    private Vector contents = new Vector();
    private Vector containers;
    private Vector varQttyContents = new Vector();
    private Vector scans;

    public ToxComplexType() {
        this.containers = new Vector();
        this.scans = new Vector();
    }

    public void addAttribute(Gene gene) {
        this.attributes.add(gene);
    }

    public void addContent(Gene gene) {
        this.contents.add(gene);
    }

    public void addContainer(ContainerGene containerGene) {
        this.containers.add(containerGene);
    }

    public void addVarQttyContent(VarQttyGene varQttyGene) {
        this.varQttyContents.add(varQttyGene);
        this.contents.add(varQttyGene);
    }

    public void addScan(ToxScan toxScan) {
        this.scans.add(toxScan);
        this.addVarQttyContent(toxScan);
    }

    public void addAll(ToxComplexType toxComplexType) {
        this.contents.addAll(toxComplexType.contents);
        this.attributes.addAll(toxComplexType.attributes);
        this.containers.addAll(toxComplexType.containers);
        this.varQttyContents.addAll(toxComplexType.varQttyContents);
    }

    public Vector attributes() {
        return this.attributes;
    }

    public Vector contents() {
        return this.contents;
    }

    public Vector containers() {
        return this.containers;
    }

    public Vector varQttyContents() {
        return this.varQttyContents;
    }

    public Vector scans() {
        return this.scans;
    }
}

