/*
 * Decompiled with CFR 0.152.
 */
package genes.trees;

import genes.ContainerGene;
import genes.Gene;
import genes.VarQttyGene;
import genes.lists.ListGene;
import genes.lists.ToxList;
import genes.lists.ToxListElement;
import genes.lists.ToxListElementException;
import genes.lists.WhereClause;
import genes.trees.NoElementsException;
import genes.trees.Query;
import genes.trees.ToxAlternatives;
import genes.trees.ToxAttribute;
import genes.trees.ToxIf;
import genes.trees.TreeGene;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Vector;
import org.w3c.dom.Node;
import parser.ToxComplexType;
import random.ToxRandom;
import random.ToxUniform;
import toxgene.ToXgene;
import util.Dictionary;
import util.DuplicateKeyException;
import util.KeyNotFoundException;

public class ToxScan
implements VarQttyGene,
TreeGene,
ListGene,
ContainerGene,
Serializable {
    private static final int SEQUENTIAL = 1;
    private static final int RANDOM = 2;
    private static final int SHUFFLE = 3;
    private static final int MASTER = 1;
    private static final int SLAVE_INDEPENDENT = 2;
    private static final int SLAVE_DEPENDENT = 3;
    private static final int LITERAL = 1;
    private static final int COMPLEX = 2;
    private boolean populated;
    private boolean isSample;
    private boolean isForeach;
    private boolean duplicates;
    private int type;
    private int mode;
    private int size;
    private ToxList list;
    private Vector elements;
    private Vector genes;
    private Vector attributes;
    private Vector containers;
    private Vector queries;
    private int current;
    private Query myQuery;
    private String absolutePath;
    private String varName;
    private ToxScan master;
    private Dictionary ancestors;
    private ToxRandom rand;
    private Vector slaves;
    private boolean[] usedElements;
    private int lastUsed;
    private WhereClause whereClause;
    private boolean isFirst;
    private boolean notUpdated;
    private Node node;
    private boolean singleToxScanClone;

    public ToxScan(String string, ToxScan toxScan, String string2, boolean bl, boolean bl2, boolean bl3, ToxRandom toxRandom, String string3, Node node) {
        String string4 = "";
        this.varName = string2;
        this.node = node;
        this.genes = new Vector();
        this.attributes = new Vector();
        this.containers = new Vector();
        this.queries = new Vector();
        this.slaves = new Vector();
        this.ancestors = new Dictionary();
        this.populated = false;
        this.isFirst = true;
        this.notUpdated = true;
        this.current = 0;
        if (toxScan != null) {
            this.ancestors = new Dictionary(toxScan.ancestors());
            if (toxScan.varName().length() != 0) {
                try {
                    this.ancestors.add(toxScan.varName(), toxScan);
                }
                catch (DuplicateKeyException duplicateKeyException) {
                    ToXgene.error("variable name: " + this.master.varName() + " alerady used!", node);
                }
            }
        }
        if (string2.length() != 0 && this.ancestors != null) {
            boolean bl4 = true;
            try {
                this.ancestors.get(string2);
            }
            catch (KeyNotFoundException keyNotFoundException) {
                bl4 = false;
            }
            if (bl4) {
                ToXgene.error("in tox-scan: " + string + " variable $" + string2 + " alerady used!", node);
            }
        }
        if (string.charAt(0) != '[' || string.charAt(string.length() - 1) != ']') {
            ToXgene.error("invalid path specified for ToxScan: " + string, node);
        }
        string4 = string.substring(1, string.length() - 1);
        if (toxScan != null) {
            toxScan.registerSlave(this);
            if (string4.charAt(0) == '$') {
                this.mode = 3;
                int n = string4.indexOf(47);
                if (n == -1) {
                    ToXgene.error("invalid cursor definition: a path within master  cursor " + string4.substring(1) + " must be specified", node);
                }
                String string5 = string4.substring(1, n);
                try {
                    this.master = (ToxScan)this.ancestors.get(string5);
                    this.myQuery = new Query("[" + string4.substring(n + 1) + "]", this.master, null, node);
                    this.master.registerQuery(this.myQuery);
                    this.absolutePath = this.master.absolutePath + "/" + this.myQuery.relativePath();
                    this.list = this.master.list;
                    if (string3.length() != 0) {
                        this.whereClause = new WhereClause(string3, this.master, node);
                    }
                }
                catch (KeyNotFoundException keyNotFoundException) {
                    ToXgene.error("cannot find master cursor \"" + string5 + "\" used in " + string, node);
                }
            } else {
                this.mode = 2;
                this.absolutePath = string4;
                String string6 = "";
                int n = 0;
                int n2 = string4.indexOf(47);
                if (n2 == -1) {
                    string6 = string4;
                    n = string4.length();
                } else {
                    string6 = string4.substring(0, n2);
                    n = n2 + 1;
                }
                try {
                    this.list = (ToxList)ToXgene.toxLists.get(string6);
                }
                catch (KeyNotFoundException keyNotFoundException) {
                    ToXgene.error("cannot find list: " + string6 + " for tox-scan", node);
                }
                this.myQuery = new Query("[" + string4.substring(n) + "]", this.list, null, node);
                if (string3.length() != 0) {
                    this.whereClause = new WhereClause(string3, this.list, string4.substring(n));
                }
            }
        } else {
            this.mode = 1;
            this.absolutePath = string4;
            String string7 = "";
            int n = 0;
            int n3 = string4.indexOf(47);
            if (n3 == -1) {
                string7 = string4;
                n = string4.length();
            } else {
                string7 = string4.substring(0, n3);
                n = n3 + 1;
            }
            try {
                this.list = (ToxList)ToXgene.toxLists.get(string7);
            }
            catch (KeyNotFoundException keyNotFoundException) {
                ToXgene.error("cannot find list: " + string7 + " for tox-scan", node);
            }
            this.myQuery = new Query("[" + string4.substring(n) + "]", this.list, null, node);
            if (string3.length() != 0) {
                this.whereClause = new WhereClause(string3, this.list, string4.substring(n));
            }
        }
        this.type = this.myQuery.expressionType() == 5 ? 2 : 1;
        this.isSample = bl2;
        if (bl2) {
            this.duplicates = bl3;
            this.rand = toxRandom;
        }
        this.isForeach = bl;
    }

    public Dictionary ancestors() {
        return this.ancestors;
    }

    public String varName() {
        return this.varName;
    }

    public String absolutePath() {
        return this.absolutePath;
    }

    public String name() {
        return "tox-scan";
    }

    public Vector children() {
        return this.genes;
    }

    public Vector getChildren() {
        if (this.genes.size() == 0) {
            throw new ToxListElementException();
        }
        Vector<ListGene> vector = null;
        int n = 0;
        while (n < this.genes.size()) {
            ListGene listGene = (ListGene)this.genes.get(n);
            if (listGene instanceof ToxIf || listGene instanceof ToxAlternatives || listGene instanceof ToxScan) {
                Vector vector2 = listGene.getChildren();
                if (vector2 != null) {
                    if (vector == null) {
                        vector = new Vector<ListGene>();
                    }
                    vector.addAll(vector2);
                }
            } else {
                if (vector == null) {
                    vector = new Vector();
                }
                vector.add(listGene);
            }
            ++n;
        }
        return vector;
    }

    public Vector getChildrenByName(String string) throws ToxListElementException {
        if (this.genes.size() == 0) {
            throw new ToxListElementException();
        }
        Vector<ListGene> vector = null;
        int n = 0;
        while (n < this.genes.size()) {
            ListGene listGene = (ListGene)this.genes.get(n);
            if (listGene instanceof ToxIf || listGene instanceof ToxAlternatives || listGene instanceof ToxScan) {
                Vector vector2 = listGene.getChildrenByName(string);
                if (vector2 != null) {
                    if (vector == null) {
                        vector = new Vector<ListGene>();
                    }
                    vector.addAll(vector2);
                }
            } else if (string.compareTo(listGene.name()) == 0) {
                if (vector == null) {
                    vector = new Vector();
                }
                vector.add(listGene);
            }
            ++n;
        }
        return vector;
    }

    public String getType() {
        switch (this.myQuery.expressionType()) {
            case 2: {
                return "integer";
            }
            case 3: {
                return "real";
            }
            case 4: {
                return "date";
            }
            case 1: {
                return "string";
            }
        }
        return "complex";
    }

    public String relativePath() {
        int n = 0;
        String string = this.absolutePath;
        do {
            if ((n = string.indexOf(47, n)) == -1) continue;
            string = string.substring(n + 1);
            n = 0;
        } while (n != -1);
        return string;
    }

    private void registerQuery(Query query) {
        this.queries.add(query);
        query.setScan(this);
    }

    public void register(Query query) {
        String string = query.scanName();
        if (string.length() == 0 || string.compareTo(this.varName) == 0) {
            this.registerQuery(query);
        } else {
            ToxScan toxScan = null;
            try {
                toxScan = (ToxScan)this.ancestors.get(string);
            }
            catch (KeyNotFoundException keyNotFoundException) {
                ToXgene.error("cannot find referenced tox-scan: " + string, this.node);
            }
            toxScan.registerQuery(query);
        }
    }

    public ToxListElement refresh() throws NoElementsException {
        if (this.current == this.size) {
            throw new NoElementsException();
        }
        return (ToxListElement)this.elements.get(this.current);
    }

    public void addComplexType(ToxComplexType toxComplexType) {
        this.genes.addAll(toxComplexType.contents());
        this.attributes.addAll(toxComplexType.attributes());
        this.containers.addAll(toxComplexType.containers());
    }

    public ToxList list() {
        return this.list;
    }

    public boolean hasAttributes() {
        return this.attributes.size() > 0;
    }

    public void generateAttributes(PrintStream printStream) {
        if (this.hasAttributes()) {
            if (!this.populated) {
                this.populate();
            }
            if (this.isFirst) {
                this.isFirst = false;
            } else {
                this.next();
            }
            this.notUpdated = false;
            int n = 0;
            while (n < this.attributes.size()) {
                ((ToxAttribute)this.attributes.get(n)).generate(printStream);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.containers.size()) {
                ((ContainerGene)this.containers.get(n2)).generateAttributes(printStream);
                ++n2;
            }
        }
    }

    public void generate(PrintStream printStream) throws NoElementsException {
        if (this.isForeach) {
            if (!this.populated) {
                this.populate();
            }
            int n = this.elements == null ? 0 : this.elements.size();
            this.isFirst = true;
            int n2 = 0;
            while (n2 < n) {
                ++n2;
                this.generateOne(printStream);
            }
        } else {
            this.generateOne(printStream);
        }
    }

    private void generateOne(PrintStream printStream) {
        if (!this.populated) {
            this.populate();
        }
        if (this.notUpdated) {
            if (this.isFirst) {
                this.isFirst = false;
            } else {
                this.next();
            }
        }
        int n = 0;
        while (n < this.queries.size()) {
            ((Query)this.queries.get(n)).stale();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.slaves.size()) {
            ((ToxScan)this.slaves.get(n2)).resetSlave();
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.genes.size()) {
            ((Gene)this.genes.get(n3)).generate(printStream);
            ++n3;
        }
        if (this.current == this.size) {
            this.populated = false;
        }
    }

    public void generateRecursive(PrintStream printStream, int n) throws NoElementsException {
        if (this.isForeach) {
            if (!this.populated) {
                this.populate();
            }
            int n2 = this.elements == null ? 0 : this.elements.size();
            this.isFirst = true;
            while (this.current < n2) {
                this.generateOneRecursive(printStream, n);
            }
        } else {
            this.generateOneRecursive(printStream, n);
        }
    }

    private void generateOneRecursive(PrintStream printStream, int n) {
        if (!this.populated) {
            this.populate();
        }
        if (this.notUpdated) {
            if (this.isFirst) {
                this.isFirst = false;
            } else {
                this.next();
            }
        }
        int n2 = 0;
        while (n2 < this.queries.size()) {
            ((Query)this.queries.get(n2)).stale();
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.slaves.size()) {
            ((ToxScan)this.slaves.get(n3)).resetSlave();
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.genes.size()) {
            Gene gene = (Gene)this.genes.get(n4);
            if (gene instanceof ToxAlternatives) {
                ((ToxAlternatives)gene).generateRecursive(printStream, n);
            } else if (gene instanceof ToxScan) {
                ((ToxScan)gene).generateRecursive(printStream, n);
            } else {
                gene.generate(printStream);
            }
            ++n4;
        }
        if (this.current == this.size) {
            this.populated = false;
        }
    }

    public void generate(ToxListElement toxListElement, ToxList toxList) throws NoElementsException {
        if (this.isForeach) {
            if (!this.populated) {
                this.populate();
            }
            int n = this.elements == null ? 0 : this.elements.size();
            this.isFirst = true;
            while (this.current < n) {
                this.generateOne(toxListElement, toxList);
            }
        } else {
            this.generateOne(toxListElement, toxList);
        }
    }

    private void generateOne(ToxListElement toxListElement, ToxList toxList) {
        if (!this.populated) {
            this.populate();
        }
        if (this.notUpdated) {
            if (this.isFirst) {
                this.isFirst = false;
            } else {
                this.next();
            }
        }
        int n = 0;
        while (n < this.queries.size()) {
            ((Query)this.queries.get(n)).stale();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.slaves.size()) {
            ((ToxScan)this.slaves.get(n2)).resetSlave();
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.genes.size()) {
            ((ListGene)this.genes.get(n3)).generate(toxListElement, toxList);
            ++n3;
        }
        if (this.current == this.size) {
            this.populated = false;
        }
    }

    public String listName() {
        return this.list.name();
    }

    private void populate() throws NoElementsException {
        int n;
        this.elements = this.myQuery.evaluateSCAN();
        int n2 = this.size = this.elements == null ? 0 : this.elements.size();
        if (this.whereClause != null) {
            n = 0;
            while (n < this.size) {
                try {
                    if (!this.whereClause.evaluate((ToxListElement)this.elements.get(n))) {
                        this.elements.removeElementAt(n);
                        --n;
                        --this.size;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    ToXgene.warning("no elements sastify" + this.whereClause.clause() + " in \"" + this.myQuery.expression() + "\"");
                }
                ++n;
            }
        }
        if (this.isSample) {
            if (!this.duplicates) {
                this.usedElements = new boolean[this.size];
                n = 0;
                while (n < this.size) {
                    this.usedElements[n] = false;
                    ++n;
                }
            }
            if (this.rand == null) {
                this.rand = new ToxUniform(0.0f, this.size - 1);
            }
            this.current = (int)this.rand.nextInt();
        } else {
            this.current = 0;
        }
        this.populated = true;
        this.isFirst = true;
        this.notUpdated = true;
    }

    public void populate2() {
        if (!this.populated) {
            this.populate();
        }
    }

    public void reset() {
        int n = 0;
        while (n < this.genes.size()) {
            ((Gene)this.genes.get(n)).reset();
            ++n;
        }
        if (this.hasAttributes()) {
            int n2 = 0;
            while (n2 < this.attributes.size()) {
                ((Gene)this.attributes.get(n2)).reset();
                ++n2;
            }
        }
    }

    public void resetSlave() {
        block3: {
            block4: {
                block2: {
                    if (this.mode != 3) break block2;
                    this.populated = false;
                    break block3;
                }
                if (this.mode != 2) break block3;
                if (!this.isSample) break block4;
                if (!this.populated) break block3;
                this.current = (int)this.rand.nextInt();
                if (this.duplicates) break block3;
                int n = 0;
                while (n < this.size) {
                    this.usedElements[n] = false;
                    ++n;
                }
                break block3;
            }
            this.current = 0;
            int n = 0;
            while (n < this.slaves.size()) {
                ((ToxScan)this.slaves.get(n)).resetSlave();
                ++n;
            }
        }
    }

    public void update() {
        if (this.populated && this.isSample && !this.duplicates) {
            int n = 0;
            while (n < this.size) {
                this.usedElements[n] = false;
                ++n;
            }
        }
    }

    public void rollback() {
        if (this.isSample && !this.duplicates) {
            this.usedElements[this.lastUsed] = false;
        } else if (this.current > 0) {
            --this.current;
        }
    }

    public int getMaxQtty() {
        if (!this.populated) {
            this.populate();
        }
        if (this.isSample && this.duplicates) {
            return -1;
        }
        if (this.isForeach) {
            return this.elements == null ? 0 : 1;
        }
        return this.size - this.current;
    }

    private void registerSlave(ToxScan toxScan) {
        this.slaves.add(toxScan);
    }

    private void next() {
        if (this.isSample) {
            if (this.duplicates) {
                this.current = (int)this.rand.nextInt();
            } else {
                this.lastUsed = this.current;
                this.usedElements[this.lastUsed] = true;
                this.current = (int)this.rand.nextInt();
                if (this.usedElements[this.current]) {
                    int n;
                    int n2;
                    int n3;
                    if (this.current < this.size - 1) {
                        int n4 = this.current;
                        n3 = n4;
                        this.current = n4 + 1;
                    } else {
                        n3 = n2 = this.size - 1;
                    }
                    if (this.current > 1) {
                        int n5 = this.current;
                        n = n5;
                        this.current = n5 - 1;
                    } else {
                        n = 0;
                    }
                    int n6 = n;
                    while (n2 < this.size - 1 && this.usedElements[n2]) {
                        ++n2;
                    }
                    while (n6 > 0 && this.usedElements[n6]) {
                        --n6;
                    }
                    this.current = this.usedElements[n2] ? n6 : (this.usedElements[n6] ? n2 : (this.current - n6 < n2 - this.current ? n6 : n2));
                }
            }
        } else {
            ++this.current;
        }
    }

    public void resetRandomGen() {
        if (this.rand != null) {
            this.rand.resetRandomGen();
        }
        int n = 0;
        while (n < this.genes.size()) {
            ((Gene)this.genes.get(n)).resetRandomGen();
            ++n;
        }
    }

    public void setLoopInterval(int n, int n2) {
        this.current = n;
        this.size = n2;
    }

    public Vector getElements() {
        return this.elements;
    }

    public void setElements(Vector vector) {
        if (this.elements != null) {
            System.out.println(" Elements has already been set");
            System.exit(2);
        }
        this.elements = vector;
        this.populated = true;
    }

    public ToxList getToxList() {
        return this.list;
    }

    public void setToxList(ToxList toxList) {
        this.list = toxList;
    }

    public void disableToxScans(Vector vector) {
        int n = this.genes.size();
        vector.add(this.queries);
        vector.add(this.myQuery);
        vector.add(this.list);
        this.queries = null;
        this.myQuery = null;
        this.list = null;
        int n2 = 0;
        while (n2 < n) {
            ((ListGene)this.genes.get(n2)).disableToxScans(vector);
            ++n2;
        }
    }

    public int enableToxScans(Vector vector, int n) {
        int n2 = this.genes.size();
        this.queries = (Vector)vector.get(n);
        this.myQuery = (Query)vector.get(++n);
        this.list = (ToxList)vector.get(++n);
        ++n;
        int n3 = 0;
        while (n3 < n2) {
            n = ((ListGene)this.genes.get(n3)).enableToxScans(vector, n);
            ++n3;
        }
        return n;
    }
}

