/*
 * Decompiled with CFR 0.152.
 */
package genes.trees;

import genes.ContainerGene;
import genes.Gene;
import genes.VarQttyGene;
import genes.lists.ListGene;
import genes.lists.ToxList;
import genes.lists.ToxListElement;
import genes.lists.ToxListElementException;
import genes.literals.LiteralGene;
import genes.trees.ToxAlternatives;
import genes.trees.ToxAttribute;
import genes.trees.ToxElement;
import genes.trees.ToxIf;
import genes.trees.ToxScan;
import genes.trees.TreeGene;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Vector;
import parser.ToxComplexType;
import random.ToxRandom;
import toxgene.ToXgene;

public class ToxRecursiveMixedContent
extends ToxElement
implements TreeGene,
ListGene,
Serializable {
    private int min_qtty;
    private int max_qtty;
    private boolean get_max_qtty = false;
    private ToxRandom randomGenerator;
    private Vector attributes;
    private Vector contents;
    private Vector containers;
    private Vector varQttyContents;
    private Vector scans;
    private boolean isLiteral;
    private boolean resetGenes;
    private int times;
    private int instance;

    public ToxRecursiveMixedContent(int n, int n2, ToxRandom toxRandom, boolean bl, boolean bl2) {
        this.min_qtty = n;
        this.max_qtty = n2;
        this.times = 0;
        this.instance = 0;
        this.get_max_qtty = n2 == -1;
        this.contents = new Vector();
        this.attributes = new Vector();
        this.containers = new Vector();
        this.varQttyContents = new Vector();
        this.scans = new Vector();
        this.randomGenerator = toxRandom;
        this.isLiteral = bl;
        this.resetGenes = bl2;
    }

    public int getQtty() {
        int n = this.min_qtty;
        int n2 = this.max_qtty;
        if (this.get_max_qtty) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.varQttyContents.size()) {
                n3 = ((VarQttyGene)this.varQttyContents.get(n4)).getMaxQtty();
                if (n2 == -1 || n3 < n2) {
                    n2 = n3;
                }
                ++n4;
            }
            if (n2 < this.min_qtty) {
                ToXgene.error("cannot generate minimun quantity of recursive mixed content element.");
            }
            n = n2;
        }
        if (this.max_qtty != -1 && this.min_qtty != n2) {
            n = (int)this.randomGenerator.nextInt(n2);
        }
        return n;
    }

    public ToxListElement instance(ToxList toxList) {
        return null;
    }

    public void failed() {
    }

    public void reset() {
        int n = 0;
        while (n < this.attributes.size()) {
            ((Gene)this.attributes.get(n)).reset();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.contents.size()) {
            ((Gene)this.contents.get(n2)).reset();
            ++n2;
        }
    }

    public void generate(ToxListElement toxListElement) {
    }

    public void generate(PrintStream printStream) {
        if (this.resetGenes) {
            this.reset();
        }
        this.times = this.getQtty();
        int n = 0;
        while (n < this.scans.size()) {
            ((ToxScan)this.scans.get(n)).update();
            ++n;
        }
        while (this.instance < this.times) {
            ++this.instance;
            int n2 = 0;
            while (n2 < this.contents.size()) {
                ((Gene)this.contents.get(n2)).generate(printStream);
                ++n2;
            }
            if (!ToXgene.addNewLine) continue;
            printStream.print("\n");
        }
        this.instance = 0;
    }

    public void generateRecursive(PrintStream printStream, int n) {
        if (this.instance < this.times) {
            ++this.instance;
            int n2 = 0;
            while (n2 < this.scans.size()) {
                ((ToxScan)this.scans.get(n2)).update();
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.contents.size()) {
                Gene gene = (Gene)this.contents.get(n3);
                if (gene instanceof ToxAlternatives) {
                    ((ToxAlternatives)gene).generateRecursive(printStream, n);
                } else if (gene instanceof ToxScan) {
                    ((ToxScan)gene).generateRecursive(printStream, n);
                } else {
                    gene.generate(printStream);
                }
                ++n3;
            }
        }
    }

    public void generateRecursive(ToxListElement toxListElement, int n) {
    }

    public void addAttribute(ToxAttribute toxAttribute) {
        ToXgene.error("recursive mixed content declarations cannot have attributes.");
    }

    public void addContent(Gene gene) {
        this.contents.add(gene);
    }

    public void addComplexType(ToxComplexType toxComplexType) {
        if (toxComplexType.attributes().size() > 0) {
            ToXgene.error("recursive mixed content declarations cannot have attributes.");
        }
        this.attributes.addAll(toxComplexType.attributes());
        this.contents.addAll(toxComplexType.contents());
        this.containers.addAll(toxComplexType.containers());
        this.varQttyContents.addAll(toxComplexType.varQttyContents());
        this.scans.addAll(toxComplexType.scans());
    }

    public void addContainer(ContainerGene containerGene) {
        this.get_max_qtty = true;
        this.containers.add(containerGene);
    }

    public void addVarQttyContent(VarQttyGene varQttyGene) {
        this.varQttyContents.add(varQttyGene);
        this.contents.add(varQttyGene);
    }

    public void addScan(ToxScan toxScan) {
        this.scans.add(toxScan);
        this.addVarQttyContent(toxScan);
    }

    public String tagName() {
        return null;
    }

    public String name() {
        return null;
    }

    public Vector children() {
        return this.contents;
    }

    public Vector getChildren() {
        Vector<ListGene> vector = null;
        int n = 0;
        while (n < this.contents.size()) {
            ListGene listGene = (ListGene)this.contents.get(n);
            if (!(listGene instanceof LiteralGene)) {
                if (listGene instanceof ToxScan || listGene instanceof ToxAlternatives || listGene instanceof ToxIf) {
                    Vector vector2 = listGene.getChildren();
                    if (vector2 != null) {
                        if (vector == null) {
                            vector = new Vector<ListGene>();
                        }
                        vector.addAll(vector2);
                    }
                } else {
                    if (vector == null) {
                        vector = new Vector();
                    }
                    vector.add(listGene);
                }
            }
            ++n;
        }
        return vector;
    }

    public Vector getChildrenByName(String string) throws ToxListElementException {
        if (this.contents.size() == 0) {
            throw new ToxListElementException();
        }
        Vector<ListGene> vector = null;
        int n = 0;
        while (n < this.contents.size()) {
            ListGene listGene = (ListGene)this.contents.get(n);
            if (!(listGene instanceof LiteralGene)) {
                if (listGene instanceof ToxScan || listGene instanceof ToxAlternatives || listGene instanceof ToxIf) {
                    Vector vector2 = listGene.getChildrenByName(string);
                    if (vector2 != null) {
                        if (vector == null) {
                            vector = new Vector<ListGene>();
                        }
                        vector.addAll(vector2);
                    }
                } else if (string.compareTo(listGene.name()) == 0) {
                    if (vector == null) {
                        vector = new Vector();
                    }
                    vector.add(listGene);
                }
            }
            ++n;
        }
        return vector;
    }

    public String getType() {
        int n = this.contents.size();
        String string = null;
        int n2 = 0;
        while (n2 < n) {
            ListGene listGene = (ListGene)this.contents.get(n2);
            if (listGene instanceof ToxElement) {
                return "complex";
            }
            if (listGene instanceof LiteralGene) {
                string = this.reconcile(string, listGene.getType());
            }
            if (listGene instanceof ToxScan || listGene instanceof ToxIf || listGene instanceof ToxAlternatives) {
                Vector vector = listGene.getChildren();
                int n3 = vector == null ? 0 : vector.size();
                int n4 = 0;
                while (n4 < n) {
                    ListGene listGene2 = (ListGene)vector.get(n4);
                    if (listGene2 instanceof ToxElement) {
                        return "complex";
                    }
                    String string2 = listGene2.getType();
                    string = this.reconcile(string, string2);
                    ++n4;
                }
            }
            ++n2;
        }
        return string;
    }

    private String reconcile(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        if (string.compareTo(string2) == 0) {
            return string;
        }
        if (string.compareTo("string") == 0 || string2.compareTo("string") == 0) {
            return "string";
        }
        if (string.compareTo("complex") == 0 || string2.compareTo("complex") == 0) {
            return "complex";
        }
        if (string.compareTo("integer") == 0 && string2.compareTo("real") == 0 || string2.compareTo("integer") == 0 && string.compareTo("real") == 0) {
            return "real";
        }
        if (string.compareTo("integer") == 0 && string2.compareTo("date") == 0 || string2.compareTo("integer") == 0 && string.compareTo("date") == 0) {
            return "date";
        }
        return "complex";
    }
}

