/*
 * Decompiled with CFR 0.152.
 */
package genes.trees;

import genes.Gene;
import genes.lists.ListGene;
import genes.lists.ToxList;
import genes.lists.ToxListElement;
import genes.trees.ToxElement;
import genes.trees.TreeGene;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Vector;
import random.ToxRandom;

public class ToxRecursiveElement
implements TreeGene,
ListGene,
Serializable {
    private long maxDepth;
    private int depth;
    private int min;
    private int max;
    private ToxElement parent;
    private ToxRandom qttyRand;
    private ToxRandom levelsRand;
    private String name;
    private int qtty = -1;
    private Gene backup;
    private Vector siblings;

    public ToxRecursiveElement(int n, int n2, ToxRandom toxRandom, String string) {
        this.min = n;
        this.max = n2;
        this.qttyRand = toxRandom;
        this.name = string;
        this.depth = 1;
    }

    public void setContent(ToxElement toxElement, ToxRandom toxRandom, Vector vector) {
        this.parent = toxElement;
        this.levelsRand = toxRandom;
        int n = vector.size();
        this.siblings = new Vector(n - 1);
        int n2 = 0;
        while (n2 < n) {
            if ((ToxRecursiveElement)vector.get(n2) != this) {
                this.siblings.add(vector.get(n2));
            }
            ++n2;
        }
        this.resetDepth();
    }

    public void generate(PrintStream printStream) {
        if ((long)this.depth < this.maxDepth) {
            this.down();
            int n = this.qtty == -1 ? this.getQtty() : this.qtty;
            int n2 = 0;
            while (n2 < n) {
                this.parent.generateRecursive(printStream, this.depth);
                ++n2;
            }
            this.up();
        } else if (this.backup != null) {
            this.backup.generate(printStream);
        }
        this.qtty = -1;
    }

    private void down() {
        ++this.depth;
        int n = 0;
        while (n < this.siblings.size()) {
            ++((ToxRecursiveElement)this.siblings.get((int)n)).depth;
            ++n;
        }
    }

    private void up() {
        --this.depth;
        int n = 0;
        while (n < this.siblings.size()) {
            --((ToxRecursiveElement)this.siblings.get((int)n)).depth;
            ++n;
        }
    }

    public void generate(ToxListElement toxListElement, ToxList toxList) {
        if ((long)this.depth < this.maxDepth) {
            ++this.depth;
            int n = this.qtty == -1 ? this.getQtty() : this.qtty;
            int n2 = 0;
            while (n2 < n) {
                this.parent.generateRecursive(toxListElement, this.depth, toxList);
                ++n2;
            }
            --this.depth;
        } else if (this.backup != null) {
            ((ListGene)((Object)this.backup)).generate(toxListElement, toxList);
        }
        this.qtty = -1;
    }

    public void resetDepth() {
        this.maxDepth = this.levelsRand.nextInt();
    }

    public void addBackup(Gene gene) {
        this.backup = gene;
    }

    public String name() {
        return this.name;
    }

    public Vector children() {
        return null;
    }

    public Vector getChildren() {
        return null;
    }

    public Vector getChildrenByName(String string) {
        return null;
    }

    public int getQtty() {
        this.qtty = this.min == this.max ? this.min : (int)this.qttyRand.nextInt();
        return this.qtty;
    }

    public String getType() {
        return "complex";
    }

    public void reset() {
    }

    public void resetRandomGen() {
        this.qttyRand.resetRandomGen();
        this.levelsRand.resetRandomGen();
    }

    public void disableToxScans(Vector vector) {
    }

    public int enableToxScans(Vector vector, int n) {
        return n;
    }
}

