/*
 * Decompiled with CFR 0.152.
 */
package genes.trees;

import genes.ContainerGene;
import genes.Gene;
import genes.lists.ListGene;
import genes.lists.ToxList;
import genes.lists.ToxListElement;
import genes.lists.ToxListElementException;
import genes.trees.ToxAlternatives;
import genes.trees.ToxAttribute;
import genes.trees.ToxIf;
import genes.trees.ToxScan;
import genes.trees.TreeGene;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Vector;

public class ToxOption
implements TreeGene,
ListGene,
ContainerGene,
Serializable {
    private Vector contents = new Vector();
    private Vector attributes = new Vector();

    public void reset() {
        int n = 0;
        while (n < this.contents.size()) {
            ((Gene)this.contents.get(n)).reset();
            ++n;
        }
    }

    public void generate(PrintStream printStream) {
        int n = 0;
        while (n < this.contents.size()) {
            ((Gene)this.contents.get(n)).generate(printStream);
            ++n;
        }
    }

    public void generate(ToxListElement toxListElement, ToxList toxList) {
        int n = 0;
        while (n < this.contents.size()) {
            ((ListGene)this.contents.get(n)).generate(toxListElement, toxList);
            ++n;
        }
    }

    public void generateAttributes(PrintStream printStream) {
        int n = 0;
        while (n < this.attributes.size()) {
            ((ToxAttribute)this.attributes.get(n)).generate(printStream);
            ++n;
        }
    }

    public boolean hasAttributes() {
        return this.attributes.size() > 0;
    }

    public void addElement(Gene gene) {
        this.contents.add(gene);
    }

    public void addAttribute(Gene gene) {
        this.attributes.add(gene);
    }

    public String getType() {
        if (this.contents.size() == 1) {
            return ((ListGene)this.contents.get(0)).getType();
        }
        return "complex";
    }

    public String name() {
        return "tox-option";
    }

    public Vector children() {
        return this.contents;
    }

    public Vector getChildren() {
        Vector<ListGene> vector = null;
        int n = 0;
        while (n < this.contents.size()) {
            ListGene listGene = (ListGene)this.contents.get(n);
            if (listGene instanceof ToxScan || listGene instanceof ToxAlternatives || listGene instanceof ToxIf) {
                Vector vector2 = listGene.getChildren();
                if (vector2 != null) {
                    if (vector == null) {
                        vector = new Vector<ListGene>();
                    }
                    vector.addAll(vector2);
                }
            } else {
                if (vector == null) {
                    vector = new Vector();
                }
                vector.add(listGene);
            }
            ++n;
        }
        return vector;
    }

    public Vector getChildrenByName(String string) throws ToxListElementException {
        Vector<ListGene> vector = null;
        int n = 0;
        while (n < this.contents.size()) {
            ListGene listGene = (ListGene)this.contents.get(n);
            if (listGene instanceof ToxScan || listGene instanceof ToxAlternatives || listGene instanceof ToxIf) {
                Vector vector2 = listGene.getChildrenByName(string);
                if (vector2 != null) {
                    if (vector == null) {
                        vector = new Vector<ListGene>();
                    }
                    vector.addAll(vector2);
                }
            } else if (string.compareTo(listGene.name()) == 0) {
                if (vector == null) {
                    vector = new Vector();
                }
                vector.add(listGene);
            }
            ++n;
        }
        return vector;
    }

    public void resetRandomGen() {
        Vector vector = this.children();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((Gene)vector.get(n2)).resetRandomGen();
            ++n2;
        }
    }

    public void disableToxScans(Vector vector) {
        Vector vector2 = this.getChildren();
        int n = vector2 == null ? 0 : vector2.size();
        int n2 = 0;
        while (n2 < n) {
            ((ListGene)vector2.get(n2)).disableToxScans(vector);
            ++n2;
        }
    }

    public int enableToxScans(Vector vector, int n) {
        Vector vector2 = this.getChildren();
        int n2 = vector2 == null ? 0 : vector2.size();
        int n3 = 0;
        while (n3 < n2) {
            n = ((ListGene)vector2.get(n3)).enableToxScans(vector, n);
            ++n3;
        }
        return n;
    }
}

