/*
 * Decompiled with CFR 0.152.
 */
package genes.trees;

import genes.ContainerGene;
import genes.Gene;
import genes.lists.ListGene;
import genes.lists.ToxList;
import genes.lists.ToxListElement;
import genes.lists.ToxListElementException;
import genes.lists.WhereClause;
import genes.trees.ToxOption;
import genes.trees.ToxScan;
import genes.trees.TreeGene;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Vector;
import org.w3c.dom.Node;

public class ToxIf
implements TreeGene,
ListGene,
ContainerGene,
Serializable {
    private WhereClause clause;
    private ToxOption thenBlock;
    private ToxOption elseBlock;
    private boolean hasElse;
    private boolean clauseResult;
    private boolean evaluated;

    public ToxIf(String string, ToxScan toxScan, ToxOption toxOption, Node node) {
        this.clause = new WhereClause(string, toxScan, node);
        this.thenBlock = toxOption;
        this.hasElse = false;
        this.evaluated = false;
    }

    public void addElseBlock(ToxOption toxOption) {
        this.elseBlock = toxOption;
        this.hasElse = true;
    }

    public void reset() {
        this.thenBlock.reset();
        if (this.hasElse) {
            this.elseBlock.reset();
        }
    }

    public void generate(PrintStream printStream) {
        if (!this.evaluated) {
            this.evaluate();
        }
        if (this.clauseResult) {
            this.thenBlock.generate(printStream);
        } else if (this.hasElse) {
            this.elseBlock.generate(printStream);
        }
        this.evaluated = false;
    }

    public void generate(ToxListElement toxListElement, ToxList toxList) {
        if (!this.evaluated) {
            this.evaluate();
        }
        if (this.clauseResult) {
            this.thenBlock.generate(toxListElement, toxList);
        } else if (this.hasElse) {
            this.elseBlock.generate(toxListElement, toxList);
        }
        this.evaluated = false;
    }

    public void generateAttributes(PrintStream printStream) {
        if (!this.evaluated) {
            this.evaluate();
        }
        if (this.clauseResult) {
            if (this.thenBlock.hasAttributes()) {
                this.thenBlock.generateAttributes(printStream);
            }
        } else if (this.hasElse && this.elseBlock.hasAttributes()) {
            this.elseBlock.generateAttributes(printStream);
        }
    }

    private void evaluate() {
        this.clauseResult = this.clause.evaluate();
        this.evaluated = true;
    }

    public String getType() {
        return "complex";
    }

    public String name() {
        return "tox-if";
    }

    public Vector children() {
        Vector vector = new Vector();
        Vector vector2 = this.thenBlock.children();
        vector.addAll(vector2);
        if (this.hasElse) {
            vector2 = this.elseBlock.children();
            vector.addAll(vector2);
        }
        return vector;
    }

    public Vector getChildren() {
        Vector vector = new Vector();
        Vector vector2 = this.thenBlock.getChildren();
        vector.addAll(vector2);
        if (this.hasElse) {
            vector2 = this.elseBlock.getChildren();
            vector.addAll(vector2);
        }
        return vector;
    }

    public Vector getChildrenByName(String string) throws ToxListElementException {
        Vector vector = null;
        Vector vector2 = this.thenBlock.getChildrenByName(string);
        if (vector2 != null) {
            vector = new Vector();
            vector.addAll(vector2);
        }
        if (this.hasElse && (vector2 = this.elseBlock.getChildrenByName(string)) != null) {
            if (vector == null) {
                vector = new Vector();
            }
            vector.addAll(vector2);
        }
        return vector;
    }

    public boolean hasAttributes() {
        if (this.thenBlock.hasAttributes()) {
            return true;
        }
        return this.hasElse && this.elseBlock.hasAttributes();
    }

    public void resetRandomGen() {
        Vector vector = this.children();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((Gene)vector.get(n2)).resetRandomGen();
            ++n2;
        }
    }

    public void disableToxScans(Vector vector) {
        Vector vector2 = this.children();
        int n = vector2 == null ? 0 : vector2.size();
        int n2 = 0;
        while (n2 < n) {
            ((ListGene)vector2.get(n2)).disableToxScans(vector);
            ++n2;
        }
    }

    public int enableToxScans(Vector vector, int n) {
        Vector vector2 = this.children();
        int n2 = vector2 == null ? 0 : vector2.size();
        int n3 = 0;
        while (n3 < n2) {
            n = ((ListGene)vector2.get(n3)).enableToxScans(vector, n);
            ++n3;
        }
        return n;
    }
}

