/*
 * Decompiled with CFR 0.152.
 */
package genes.trees;

import genes.lists.ToxList;
import genes.trees.ToxElement;
import genes.trees.TreeGene;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Vector;
import toxgene.ToXgene;

public class ToxFile
implements TreeGene,
Serializable {
    private PrintStream outStream;
    private String name;
    private String doctype;
    private int copies;
    private int start;
    private boolean hasDTD = false;
    private Vector uses;
    private ToxElement root;
    private boolean pad;

    public ToxFile(String string, int n, int n2, ToxElement toxElement, boolean bl) {
        this.copies = n;
        this.start = n2;
        this.name = string;
        this.root = toxElement;
        this.pad = bl;
    }

    public ToxFile(String string, int n, int n2, String string2, ToxElement toxElement, boolean bl) {
        this.copies = n;
        this.start = n2;
        this.name = string;
        this.root = toxElement;
        this.doctype = string2;
        this.pad = bl;
        this.hasDTD = true;
    }

    public void references(Vector vector) {
        this.uses = vector;
        int n = 0;
        while (n < this.uses.size()) {
            ((ToxList)this.uses.get(n)).addReference();
            ++n;
        }
    }

    public void generate() {
        String string;
        Object object;
        Object object2;
        if (this.copies > 1) {
            int n;
            object2 = "####";
            if (this.pad) {
                int n2 = this.copies;
                while (n2 > 0) {
                    object2 = (String)object2 + "0";
                    n2 /= 10;
                }
            }
            object = new DecimalFormat((String)object2);
            System.out.print("Generating collection: " + this.name + "     ");
            int n3 = n = this.copies > 19 ? this.copies / 19 : 19;
            if (n * 19 < this.copies) {
                ++n;
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = this.start;
            while (n6 < this.start + this.copies) {
                string = this.name + ((NumberFormat)object).format(n6) + ".xml";
                try {
                    this.outStream = new PrintStream(new FileOutputStream(string));
                }
                catch (Exception exception) {
                    System.out.println("Couldn't create " + string);
                    System.exit(1);
                }
                this.outStream.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                this.outStream.println("<!-- generated by ToXgene Version 1.1a on " + new Date().toString() + " -->");
                if (this.hasDTD) {
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.doctype));
                        this.outStream.println("<!DOCTYPE " + this.root.tagName() + "[");
                        String string2 = bufferedReader.readLine();
                        while (string2 != null) {
                            this.outStream.println(string2);
                            string2 = bufferedReader.readLine();
                        }
                        this.outStream.println("]>");
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.outStream.println("<!DOCTYPE " + this.root.tagName() + " SYSTEM \"" + this.doctype + "\">");
                    }
                    catch (IOException iOException) {
                        ToXgene.error("IO exception while attempting to read " + this.doctype);
                    }
                }
                this.outStream.println();
                this.root.generate(this.outStream);
                this.outStream.close();
                if (++n4 >= n) {
                    System.out.print("\b\b\b" + (n5 += 5) + "%");
                    n4 = 0;
                }
                ++n6;
            }
            System.out.println("\b\b\bDone!");
        } else {
            System.out.print("Generating document: " + this.name + " ");
            string = this.name + ".xml";
            try {
                this.outStream = new PrintStream(new FileOutputStream(string));
            }
            catch (Exception exception) {
                System.out.println("Couldn't create " + string);
                System.exit(1);
            }
            this.outStream.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
            this.outStream.println("<!-- generated by ToXgene Version 1.1a in " + new Date().toString() + " -->");
            if (this.hasDTD) {
                try {
                    object2 = new BufferedReader(new FileReader(this.doctype));
                    this.outStream.println("<!DOCTYPE " + this.root.tagName() + "[");
                    object = ((BufferedReader)object2).readLine();
                    while (object != null) {
                        this.outStream.println((String)object);
                        object = ((BufferedReader)object2).readLine();
                    }
                    this.outStream.println("]>");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.outStream.println("<!DOCTYPE " + this.root.tagName() + " SYSTEM \"" + this.doctype + "\">");
                }
                catch (IOException iOException) {
                    ToXgene.error("IO exception while attempting to read " + this.doctype);
                }
            }
            this.outStream.println();
            this.root.generate(this.outStream);
            this.outStream.close();
            System.out.println("Done!");
        }
        if (this.uses != null) {
            int n = 0;
            while (n < this.uses.size()) {
                ((ToxList)this.uses.get(n)).removeReference();
                ++n;
            }
        }
    }

    public void reset() {
        ToXgene.error("DIED A HORRIBLE DEATH!");
    }

    public void generate(PrintStream printStream) {
        ToXgene.error("DIED A HORRIBLE DEATH!");
    }

    public Vector getChildren() {
        ToXgene.error("DIED A HORRIBLE DEATH!");
        return null;
    }

    public Vector children() {
        ToXgene.error("DIED A HORRIBLE DEATH!");
        return null;
    }

    public void resetRandomGen() {
    }
}

