/*
 * Decompiled with CFR 0.152.
 */
package genes.trees;

import genes.ContainerGene;
import genes.Gene;
import genes.VarQttyGene;
import genes.lists.ListGene;
import genes.lists.ToxList;
import genes.lists.ToxListElement;
import genes.lists.ToxListElementException;
import genes.literals.LiteralGene;
import genes.trees.NoElementsException;
import genes.trees.ToxAlternatives;
import genes.trees.ToxAttribute;
import genes.trees.ToxIf;
import genes.trees.ToxScan;
import genes.trees.TreeGene;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Vector;
import parser.ToxComplexType;
import random.ToxRandom;
import toxgene.ToXgene;

public class ToxElement
implements TreeGene,
ListGene,
Serializable {
    private String tagname;
    private int min_qtty;
    private int max_qtty;
    private boolean get_max_qtty = false;
    private ToxRandom randomGenerator;
    private Vector attributes;
    private Vector contents;
    private Vector containers;
    private Vector varQttyContents;
    private Vector scans;
    private boolean isLiteral;
    private boolean resetGenes;
    private int times;
    private int instance;

    public ToxElement() {
    }

    public ToxElement(String string, int n, int n2, ToxRandom toxRandom, boolean bl, boolean bl2) {
        this.tagname = string;
        this.min_qtty = n;
        this.max_qtty = n2;
        this.times = 0;
        this.instance = 0;
        this.get_max_qtty = n2 == -1;
        this.contents = new Vector();
        this.attributes = new Vector();
        this.containers = new Vector();
        this.varQttyContents = new Vector();
        this.scans = new Vector();
        this.randomGenerator = toxRandom;
        this.isLiteral = bl;
        this.resetGenes = bl2;
    }

    public int getQtty() {
        int n = this.min_qtty;
        int n2 = this.max_qtty;
        if (this.get_max_qtty) {
            int n3 = 0;
            int n4 = this.varQttyContents.size();
            int n5 = 0;
            while (n5 < n4) {
                n3 = ((VarQttyGene)this.varQttyContents.get(n5)).getMaxQtty();
                if (n2 == -1 || n3 < n2) {
                    n2 = n3;
                }
                ++n5;
            }
            if (n2 < this.min_qtty) {
                ToXgene.error("cannot generate minimun quantity of \"" + this.tagname + "\" element.");
            }
            n = n2;
        }
        if (this.max_qtty != -1 && this.min_qtty != n2) {
            n = (int)this.randomGenerator.nextInt(n2);
        }
        return n;
    }

    public ToxListElement instance(ToxList toxList) {
        int n = ToXgene.getTagNumber(this.tagname);
        ToxListElement toxListElement = new ToxListElement(n);
        if (this.resetGenes) {
            this.reset();
        }
        try {
            int n2 = this.contents.size();
            int n3 = 0;
            while (n3 < n2) {
                ((ListGene)this.contents.get(n3)).generate(toxListElement, toxList);
                ++n3;
            }
        }
        catch (NoElementsException noElementsException) {
            ToXgene.error("cannot generate more instances of element: " + this.tagname + "\n\n" + noElementsException.getMessage());
        }
        return toxListElement;
    }

    public void failed() {
        int n = this.scans.size();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                ((ToxScan)this.scans.get(n2)).rollback();
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                if ((Gene)this.contents.get(n3) instanceof ToxElement) {
                    ((ToxElement)this.contents.get(n3)).failed();
                }
                ++n3;
            }
        }
    }

    public void reset() {
        int n = this.attributes.size();
        int n2 = 0;
        while (n2 < n) {
            ((Gene)this.attributes.get(n2)).reset();
            ++n2;
        }
        n = this.contents.size();
        int n3 = 0;
        while (n3 < n) {
            ((Gene)this.contents.get(n3)).reset();
            ++n3;
        }
    }

    public void generate(ToxListElement toxListElement, ToxList toxList) {
        if (this.resetGenes) {
            this.reset();
        }
        this.times = this.getQtty();
        try {
            int n = this.scans.size();
            int n2 = 0;
            while (n2 < n) {
                ((ToxScan)this.scans.get(n2)).update();
                ++n2;
            }
            this.instance = 0;
            while (this.instance < this.times) {
                int n3 = ToXgene.getTagNumber(this.tagname);
                ToxListElement toxListElement2 = toxListElement.addChild(n3);
                int n4 = this.contents.size();
                int n5 = 0;
                while (n5 < n4) {
                    ((ListGene)this.contents.get(n5)).generate(toxListElement2, toxList);
                    ++n5;
                }
                ++this.instance;
            }
        }
        catch (NoElementsException noElementsException) {
            noElementsException.printStackTrace();
            ToXgene.error("cannot generate more instances of element: " + this.tagname + "\n\n" + noElementsException.getMessage());
        }
    }

    public void generate(PrintStream printStream) {
        if (this.resetGenes) {
            this.reset();
        }
        this.times = this.getQtty();
        int n = this.scans.size();
        int n2 = 0;
        while (n2 < n) {
            ((ToxScan)this.scans.get(n2)).update();
            ++n2;
        }
        while (this.instance < this.times) {
            ++this.instance;
            try {
                printStream.print("<" + this.tagname);
                int n3 = this.attributes.size();
                int n4 = 0;
                while (n4 < n3) {
                    ((Gene)this.attributes.get(n4)).generate(printStream);
                    ++n4;
                }
                n3 = this.containers.size();
                int n5 = 0;
                while (n5 < n3) {
                    ((ContainerGene)this.containers.get(n5)).generateAttributes(printStream);
                    ++n5;
                }
                printStream.print(">");
                n3 = this.contents.size();
                int n6 = 0;
                while (n6 < n3) {
                    ((Gene)this.contents.get(n6)).generate(printStream);
                    ++n6;
                }
                printStream.print("</" + this.tagname + ">");
            }
            catch (NoElementsException noElementsException) {
                ToXgene.error("cannot generate more instances of element: " + this.tagname + "\n\n" + noElementsException.getMessage());
            }
            if (!ToXgene.addNewLine) continue;
            printStream.print("\n");
        }
        this.instance = 0;
    }

    public void generateRecursive(PrintStream printStream, int n) {
        if (this.instance < this.times) {
            ++this.instance;
            int n2 = this.scans.size();
            int n3 = 0;
            while (n3 < n2) {
                ((ToxScan)this.scans.get(n3)).update();
                ++n3;
            }
            try {
                printStream.print("<" + this.tagname);
                int n4 = this.attributes.size();
                int n5 = 0;
                while (n5 < n4) {
                    ((Gene)this.attributes.get(n5)).generate(printStream);
                    ++n5;
                }
                n4 = this.containers.size();
                int n6 = 0;
                while (n6 < n4) {
                    ((ContainerGene)this.containers.get(n6)).generateAttributes(printStream);
                    ++n6;
                }
                printStream.print(">");
                n4 = this.contents.size();
                int n7 = 0;
                while (n7 < n4) {
                    Gene gene = (Gene)this.contents.get(n7);
                    if (gene instanceof ToxAlternatives) {
                        ((ToxAlternatives)gene).generateRecursive(printStream, n);
                    } else if (gene instanceof ToxScan) {
                        ((ToxScan)gene).generateRecursive(printStream, n);
                    } else {
                        gene.generate(printStream);
                    }
                    ++n7;
                }
            }
            catch (NoElementsException noElementsException) {
                ToXgene.error("cannot generate more instances of element: " + this.tagname + "\n\n" + noElementsException.getMessage());
            }
            printStream.print("</" + this.tagname + ">");
        }
    }

    public void generateRecursive(ToxListElement toxListElement, int n, ToxList toxList) {
        if (this.instance < this.times) {
            ++this.instance;
            int n2 = this.scans.size();
            int n3 = 0;
            while (n3 < n2) {
                ((ToxScan)this.scans.get(n3)).update();
                ++n3;
            }
            try {
                int n4 = ToXgene.getTagNumber(this.tagname);
                ToxListElement toxListElement2 = toxListElement.addChild(n4);
                int n5 = this.contents.size();
                int n6 = 0;
                while (n6 < n5) {
                    ListGene listGene = (ListGene)this.contents.get(n6);
                    if (listGene instanceof ToxAlternatives) {
                        ((ToxAlternatives)listGene).generateRecursive(toxListElement2, n, toxList);
                    } else {
                        listGene.generate(toxListElement2, toxList);
                    }
                    ++n6;
                }
            }
            catch (NoElementsException noElementsException) {
                ToXgene.error("cannot generate more instances of element: " + this.tagname + "\n\n" + noElementsException.getMessage());
            }
        }
    }

    public void addAttribute(ToxAttribute toxAttribute) {
        this.attributes.add(toxAttribute);
    }

    public void addContent(Gene gene) {
        this.contents.add(gene);
    }

    public void addComplexType(ToxComplexType toxComplexType) {
        this.attributes.addAll(toxComplexType.attributes());
        this.contents.addAll(toxComplexType.contents());
        this.containers.addAll(toxComplexType.containers());
        this.varQttyContents.addAll(toxComplexType.varQttyContents());
        this.scans.addAll(toxComplexType.scans());
    }

    public void addContainer(ContainerGene containerGene) {
        this.get_max_qtty = true;
        this.containers.add(containerGene);
    }

    public void addVarQttyContent(VarQttyGene varQttyGene) {
        this.varQttyContents.add(varQttyGene);
        this.contents.add(varQttyGene);
    }

    public void addScan(ToxScan toxScan) {
        this.scans.add(toxScan);
        this.addVarQttyContent(toxScan);
    }

    public String tagName() {
        return this.tagname;
    }

    public String name() {
        return this.tagname;
    }

    public Vector children() {
        return this.contents;
    }

    public Vector getChildren() {
        Vector<ListGene> vector = null;
        int n = this.contents.size();
        int n2 = 0;
        while (n2 < n) {
            ListGene listGene = (ListGene)this.contents.get(n2);
            if (!(listGene instanceof LiteralGene)) {
                if (listGene instanceof ToxScan || listGene instanceof ToxAlternatives || listGene instanceof ToxIf) {
                    Vector vector2 = listGene.getChildren();
                    if (vector2 != null) {
                        if (vector == null) {
                            vector = new Vector<ListGene>();
                        }
                        vector.addAll(vector2);
                    }
                } else {
                    if (vector == null) {
                        vector = new Vector();
                    }
                    vector.add(listGene);
                }
            }
            ++n2;
        }
        return vector;
    }

    public Vector getChildrenByName(String string) throws ToxListElementException {
        int n = this.contents.size();
        if (n == 0) {
            throw new ToxListElementException();
        }
        Vector<ListGene> vector = null;
        int n2 = 0;
        while (n2 < n) {
            ListGene listGene = (ListGene)this.contents.get(n2);
            if (!(listGene instanceof LiteralGene)) {
                if (listGene instanceof ToxScan || listGene instanceof ToxAlternatives || listGene instanceof ToxIf) {
                    Vector vector2 = listGene.getChildrenByName(string);
                    if (vector2 != null) {
                        if (vector == null) {
                            vector = new Vector<ListGene>();
                        }
                        vector.addAll(vector2);
                    }
                } else if (string.compareTo(listGene.name()) == 0) {
                    if (vector == null) {
                        vector = new Vector();
                    }
                    vector.add(listGene);
                }
            }
            ++n2;
        }
        return vector;
    }

    public String getType() {
        int n = this.contents.size();
        String string = null;
        int n2 = 0;
        while (n2 < n) {
            ListGene listGene = (ListGene)this.contents.get(n2);
            if (listGene instanceof ToxElement) {
                return "complex";
            }
            if (listGene instanceof LiteralGene) {
                string = this.reconcile(string, listGene.getType());
            }
            if (listGene instanceof ToxScan || listGene instanceof ToxIf || listGene instanceof ToxAlternatives) {
                Vector vector = listGene.getChildren();
                int n3 = vector == null ? 0 : vector.size();
                int n4 = 0;
                while (n4 < n) {
                    ListGene listGene2 = (ListGene)vector.get(n4);
                    if (listGene2 instanceof ToxElement) {
                        return "complex";
                    }
                    String string2 = listGene2.getType();
                    string = this.reconcile(string, string2);
                    ++n4;
                }
            }
            ++n2;
        }
        return string;
    }

    private String reconcile(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        if (string.compareTo(string2) == 0) {
            return string;
        }
        if (string.compareTo("string") == 0 || string2.compareTo("string") == 0) {
            return "string";
        }
        if (string.compareTo("complex") == 0 || string2.compareTo("complex") == 0) {
            return "complex";
        }
        if (string.compareTo("integer") == 0 && string2.compareTo("real") == 0 || string2.compareTo("integer") == 0 && string.compareTo("real") == 0) {
            return "real";
        }
        if (string.compareTo("integer") == 0 && string2.compareTo("date") == 0 || string2.compareTo("integer") == 0 && string.compareTo("date") == 0) {
            return "date";
        }
        return "complex";
    }

    public void resetRandomGen() {
        if (this.randomGenerator != null) {
            this.randomGenerator.resetRandomGen();
        }
        Vector vector = this.children();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((Gene)vector.get(n2)).resetRandomGen();
            ++n2;
        }
    }

    public int numToxScans() {
        int n = 0;
        int n2 = this.contents.size();
        int n3 = 0;
        while (n3 < n2) {
            if ((ListGene)this.contents.get(n3) instanceof ToxScan) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    public void setLoopInterval(int n, int n2) {
        ToxScan toxScan = (ToxScan)this.contents.get(0);
        if (toxScan != null) {
            toxScan.setLoopInterval(n, n2);
        }
    }

    public void setElements(Vector vector) {
        ToxScan toxScan = (ToxScan)this.contents.get(0);
        toxScan.setElements(vector);
    }

    public Vector getElements() {
        try {
            ToxScan toxScan = (ToxScan)this.contents.get(0);
            return toxScan.getElements();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ToxList getToxList() {
        ToxScan toxScan = (ToxScan)this.contents.get(0);
        return toxScan.getToxList();
    }

    public void setToxList(ToxList toxList) {
        ToxScan toxScan = (ToxScan)this.contents.get(0);
        toxScan.setToxList(toxList);
    }

    public void populate() {
        ToxScan toxScan = (ToxScan)this.contents.get(0);
        toxScan.populate2();
    }

    public void disableToxScans(Vector vector) {
        int n = this.contents.size();
        int n2 = 0;
        while (n2 < n) {
            ((ListGene)this.contents.get(n2)).disableToxScans(vector);
            ++n2;
        }
    }

    public int enableToxScans(Vector vector, int n) {
        int n2 = this.contents.size();
        int n3 = 0;
        while (n3 < n2) {
            n = ((ListGene)this.contents.get(n3)).enableToxScans(vector, n);
            ++n3;
        }
        return n;
    }
}

