/*
 * Decompiled with CFR 0.152.
 */
package genes.trees;

import genes.Gene;
import genes.VarQttyGene;
import genes.trees.ToxScan;
import genes.trees.TreeGene;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Vector;
import random.ToxRandom;

public class ToxAttribute
implements TreeGene,
Serializable {
    private String name;
    private Gene contents;
    private int min_qtty;
    private int max_qtty;
    private boolean get_max_qtty;
    private char separator;
    private ToxRandom randomGenerator;

    public ToxAttribute(String string, int n, int n2, Gene gene, ToxRandom toxRandom, boolean bl, char c) {
        this.name = string;
        this.contents = gene;
        this.randomGenerator = toxRandom;
        this.min_qtty = n;
        this.max_qtty = n2;
        this.get_max_qtty = bl;
        this.separator = (char)(c == '\u0000' ? 44 : (int)c);
        bl = this.max_qtty == -1;
    }

    public void reset() {
        this.contents.reset();
    }

    public void generate(PrintStream printStream) {
        int n = this.getQtty();
        if (n > 0) {
            if (this.contents instanceof ToxScan) {
                ((ToxScan)this.contents).update();
            }
            printStream.print(" " + this.name + "=\"");
            this.contents.generate(printStream);
            int n2 = 1;
            while (n2 < n) {
                printStream.print(this.separator);
                this.contents.generate(printStream);
                ++n2;
            }
            printStream.print("\"");
        }
    }

    private int getQtty() {
        int n = this.min_qtty;
        int n2 = this.min_qtty;
        if (this.get_max_qtty) {
            n2 = ((VarQttyGene)((Object)this.contents)).getMaxQtty();
            if (this.max_qtty != -1 && this.max_qtty < n2) {
                n2 = this.max_qtty;
            }
            if (this.max_qtty == -1) {
                n = n2;
            } else if (n2 != this.min_qtty) {
                n = (int)this.randomGenerator.nextInt(n2);
            }
        } else {
            n = (int)this.randomGenerator.nextInt();
        }
        return n;
    }

    public Vector getChildren() {
        return null;
    }

    public Vector children() {
        return null;
    }

    public void resetRandomGen() {
        this.randomGenerator.resetRandomGen();
    }
}

