/*
 * Decompiled with CFR 0.152.
 */
package genes.trees;

import genes.ContainerGene;
import genes.Gene;
import genes.lists.ListGene;
import genes.lists.ToxList;
import genes.lists.ToxListElement;
import genes.lists.ToxListElementException;
import genes.trees.ToxOption;
import genes.trees.TreeGene;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Vector;
import random.ToxRandom;
import util.FloatObjectPair;

public class ToxAlternatives
implements TreeGene,
ContainerGene,
ListGene,
Serializable {
    private Vector options = new Vector();
    private float mass = 0.0f;
    private ToxRandom randomGenerator;
    private boolean[] drawn;
    private FloatObjectPair[] chosen;
    private int level = 0;

    public ToxAlternatives(ToxRandom toxRandom) {
        this.randomGenerator = toxRandom;
        this.drawn = new boolean[1];
        this.chosen = new FloatObjectPair[1];
        this.drawn[this.level] = false;
    }

    public void reset() {
        int n = 0;
        while (n < this.options.size()) {
            FloatObjectPair floatObjectPair = (FloatObjectPair)this.options.get(n);
            ((ToxOption)floatObjectPair.value()).reset();
            ++n;
        }
    }

    public void generate(PrintStream printStream) {
        if (!this.drawn[this.level]) {
            this.draw(this.level);
        }
        ((Gene)this.chosen[this.level].value()).generate(printStream);
        this.drawn[this.level] = false;
    }

    public void generate(ToxListElement toxListElement, ToxList toxList) {
        if (!this.drawn[this.level]) {
            this.draw(this.level);
        }
        ((ListGene)this.chosen[this.level].value()).generate(toxListElement, toxList);
        this.drawn[this.level] = false;
    }

    public void generateAttributes(PrintStream printStream) {
        if (!this.drawn[this.level]) {
            this.draw(this.level);
        }
        ((ContainerGene)this.chosen[this.level].value()).generateAttributes(printStream);
    }

    /*
     * Unable to fully structure code
     */
    public void generateRecursive(PrintStream var1_1, int var2_2) {
        block4: {
            try {
                if (!this.drawn[var2_2 - 1]) {
                    this.draw(var2_2 - 1);
                }
                break block4;
            }
            catch (ArrayIndexOutOfBoundsException var3_3) {
                var4_4 = this.drawn;
                this.drawn = new boolean[var4_4.length + 1];
                var5_5 = this.chosen;
                this.chosen = new FloatObjectPair[var5_5.length + 1];
                var6_6 = 0;
                ** while (var6_6 < var4_4.length)
            }
lbl-1000:
            // 1 sources

            {
                this.drawn[var6_6] = var4_4[var6_6];
                this.chosen[var6_6] = var5_5[var6_6];
                ++var6_6;
                continue;
            }
lbl16:
            // 1 sources

            this.draw(var2_2 - 1);
        }
        ((ToxOption)this.chosen[var2_2 - 1].value()).generate(var1_1);
        this.drawn[var2_2 - 1] = false;
    }

    /*
     * Unable to fully structure code
     */
    public void generateRecursive(ToxListElement var1_1, int var2_2, ToxList var3_3) {
        block4: {
            try {
                if (!this.drawn[var2_2 - 1]) {
                    this.draw(var2_2 - 1);
                }
                break block4;
            }
            catch (ArrayIndexOutOfBoundsException var4_4) {
                var5_5 = this.drawn;
                this.drawn = new boolean[var5_5.length + 1];
                var6_6 = this.chosen;
                this.chosen = new FloatObjectPair[var6_6.length + 1];
                var7_7 = 0;
                ** while (var7_7 < var5_5.length)
            }
lbl-1000:
            // 1 sources

            {
                this.drawn[var7_7] = var5_5[var7_7];
                this.chosen[var7_7] = var6_6[var7_7];
                ++var7_7;
                continue;
            }
lbl16:
            // 1 sources

            this.draw(var2_2 - 1);
        }
        ((ListGene)this.chosen[var2_2 - 1].value()).generate(var1_1, var3_3);
        this.drawn[var2_2 - 1] = false;
    }

    public boolean hasAttributes() {
        int n = 0;
        while (n < this.options.size()) {
            FloatObjectPair floatObjectPair = (FloatObjectPair)this.options.get(n);
            if (((ToxOption)floatObjectPair.value()).hasAttributes()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Vector children() {
        Vector vector = new Vector();
        int n = 0;
        while (n < this.options.size()) {
            FloatObjectPair floatObjectPair = (FloatObjectPair)this.options.get(n);
            Vector vector2 = ((ToxOption)floatObjectPair.value()).children();
            if (vector2 != null) {
                vector.addAll(vector2);
            }
            ++n;
        }
        return vector;
    }

    public Vector getChildren() {
        Vector vector = null;
        int n = 0;
        while (n < this.options.size()) {
            FloatObjectPair floatObjectPair = (FloatObjectPair)this.options.get(n);
            Vector vector2 = ((ToxOption)floatObjectPair.value()).getChildren();
            if (vector2 != null) {
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addAll(vector2);
            }
            ++n;
        }
        return vector;
    }

    public Vector getChildrenByName(String string) throws ToxListElementException {
        Vector vector = null;
        FloatObjectPair floatObjectPair = (FloatObjectPair)this.options.get(0);
        Vector vector2 = ((ToxOption)floatObjectPair.value()).getChildrenByName(string);
        if (vector2 != null) {
            vector = new Vector();
            vector.addAll(vector2);
        }
        int n = 1;
        while (n < this.options.size()) {
            floatObjectPair = (FloatObjectPair)this.options.get(n);
            vector2 = ((ToxOption)floatObjectPair.value()).getChildrenByName(string);
            if (vector2 != null) {
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addAll(vector2);
            }
            ++n;
        }
        return vector;
    }

    public String name() {
        return "tox-alternatives";
    }

    public String getType() {
        FloatObjectPair floatObjectPair = (FloatObjectPair)this.options.get(0);
        String string = ((ToxOption)floatObjectPair.value()).getType();
        int n = 1;
        while (n < this.options.size()) {
            floatObjectPair = (FloatObjectPair)this.options.get(n);
            String string2 = ((ToxOption)floatObjectPair.value()).getType();
            string = this.reconcile(string, string2);
            ++n;
        }
        return string;
    }

    private String reconcile(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        if (string.compareTo(string2) == 0) {
            return string;
        }
        if (string.compareTo("string") == 0 || string2.compareTo("string") == 0) {
            return "string";
        }
        if (string.compareTo("complex") == 0 || string2.compareTo("complex") == 0) {
            return "complex";
        }
        if (string.compareTo("integer") == 0 && string2.compareTo("real") == 0 || string2.compareTo("integer") == 0 && string.compareTo("real") == 0) {
            return "real";
        }
        if (string.compareTo("integer") == 0 && string2.compareTo("date") == 0 || string2.compareTo("integer") == 0 && string.compareTo("date") == 0) {
            return "date";
        }
        return "complex";
    }

    public void draw(int n) {
        float f = this.randomGenerator.nextFloat();
        int n2 = 0;
        this.chosen[n] = (FloatObjectPair)this.options.get(n2);
        while (f > this.chosen[n].key()) {
            ++n2;
            try {
                this.chosen[n] = (FloatObjectPair)this.options.get(n2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                break;
            }
        }
        this.drawn[n] = true;
    }

    public void addOption(float f, Gene gene) {
        this.mass += f;
        if ((double)this.mass > 100.0) {
            System.out.println("***** Error: invalid probability distribution!!!");
            System.exit(1);
        }
        this.options.add(new FloatObjectPair(this.mass, gene));
    }

    public void resetRandomGen() {
        this.randomGenerator.resetRandomGen();
        Vector vector = this.children();
        int n = vector == null ? 0 : vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((Gene)vector.get(n2)).resetRandomGen();
            ++n2;
        }
    }

    public void disableToxScans(Vector vector) {
        Vector vector2 = this.getChildren();
        int n = vector2 == null ? 0 : vector2.size();
        int n2 = 0;
        while (n2 < n) {
            ((ListGene)vector2.get(n2)).disableToxScans(vector);
            ++n2;
        }
    }

    public int enableToxScans(Vector vector, int n) {
        Vector vector2 = this.getChildren();
        int n2 = vector2 == null ? 0 : vector2.size();
        int n3 = 0;
        while (n3 < n2) {
            n = ((ListGene)vector2.get(n3)).enableToxScans(vector, n);
            ++n3;
        }
        return n;
    }
}

