/*
 * Decompiled with CFR 0.152.
 */
package genes.trees;

import genes.lists.PathNotFoundException;
import genes.lists.ToxList;
import genes.lists.ToxListElement;
import genes.lists.ToxListElementException;
import genes.trees.Expression;
import genes.trees.ToxScan;
import java.io.Serializable;
import java.util.Collections;
import java.util.Vector;
import org.w3c.dom.Node;
import toxgene.ToXgene;
import util.Date;
import util.ToxVector;

public class Query
implements Expression,
Serializable {
    private static final int NOP = 0;
    private static final int SUM = 1;
    private static final int AVG = 2;
    private static final int MIN = 3;
    private static final int MAX = 4;
    private static final int COUNT = 5;
    private static final int LEN = 6;
    private static final int CONCAT = 7;
    private static final int DISTINCT = 8;
    private static final int LIST = 1;
    private static final int SCAN = 2;
    private String scanName;
    private String path;
    private String absolutePath;
    private String relativePath;
    private String type;
    private int resultType;
    private int AGG;
    private int DT;
    private ToxList list;
    private boolean fresh;
    private boolean copy_literal;
    private boolean copy_tag;
    private ToxScan scan;
    private Vector result;
    private int mode;
    private String expression;
    private String prefix;
    private Node node;

    public Query(String string, ToxList toxList, String string2, Node node) {
        this.list = toxList;
        this.prefix = string2;
        this.node = node;
        this.mode = 1;
        this.initialize(string);
    }

    public Query(String string, ToxScan toxScan, String string2, Node node) {
        if (toxScan == null) {
            ToXgene.error("path expression " + string + " declared outside the scope \n" + "of a tox-scan or tox-sample element!", node);
        }
        this.scan = toxScan;
        this.prefix = string2;
        this.node = node;
        this.mode = 2;
        this.initialize(string);
        this.list = toxScan.list();
    }

    private void initialize(String string) {
        this.expression = string;
        int n = 0;
        this.copy_tag = false;
        this.copy_literal = false;
        this.fresh = false;
        int n2 = string.indexOf(91, 0);
        if (n2 == -1) {
            ToXgene.error("could not parse a query from: " + string, this.node);
        }
        if ((n2 = string.indexOf(93, n = n2 + 1)) == -1) {
            ToXgene.error("could not parse a query from: " + string, this.node);
        }
        this.path = string.substring(n, n2);
        if (this.mode == 2) {
            if (this.path.charAt(0) == '$') {
                int n3 = this.path.indexOf(47);
                this.scanName = this.path.substring(1, n3);
                this.path = this.path.substring(n3 + 1);
            } else {
                this.scanName = "";
            }
            this.relativePath = this.path;
            this.scan.register(this);
            if (this.relativePath.compareTo("!") == 0) {
                this.copy_literal = true;
                this.absolutePath = this.scan.absolutePath();
                this.type = this.scan.getType();
            } else if (this.relativePath.compareTo("~") == 0) {
                this.copy_tag = true;
                this.absolutePath = this.scan.absolutePath();
                this.type = "string";
            } else {
                this.path = this.scan.relativePath() + "/" + this.path;
                this.absolutePath = this.scan.absolutePath() + "/" + this.relativePath;
                if (this.path.charAt(this.path.length() - 1) == '/') {
                    this.type = "complex";
                } else {
                    try {
                        this.type = this.scan.list().getType(this.absolutePath);
                    }
                    catch (PathNotFoundException pathNotFoundException) {
                        ToXgene.error("invalid path [" + this.absolutePath + "] defining query.", this.node);
                    }
                }
            }
        } else {
            if (this.prefix != null) {
                this.path = this.prefix + "/" + this.path;
            }
            this.absolutePath = this.path.length() != 0 ? this.list.name() + "/" + this.path : this.list.name();
            if (this.path.charAt(this.path.length() - 1) == '/') {
                this.type = "complex";
            } else {
                try {
                    this.type = this.list.getType(this.absolutePath);
                }
                catch (PathNotFoundException pathNotFoundException) {
                    ToXgene.error("invalid path [" + this.absolutePath + "] defining query.", this.node);
                }
            }
        }
        if (this.type.compareTo("string") == 0) {
            this.DT = 1;
        } else if (this.type.compareTo("integer") == 0) {
            this.DT = 2;
        } else if (this.type.compareTo("real") == 0) {
            this.DT = 3;
        } else if (this.type.compareTo("date") == 0) {
            this.DT = 4;
        } else {
            if (this.type.compareTo("complex") != 0) {
                ToXgene.error("Spurious datatype in Query.java!", this.node);
            }
            this.DT = 5;
            this.AGG = 0;
        }
        this.AGG = 0;
        String string2 = string.substring(0, n - 1);
        this.resultType = this.DT;
        if (string2.length() != 0) {
            if (string2.compareTo("SUM") == 0) {
                this.AGG = 1;
            } else if (string2.compareTo("AVG") == 0) {
                this.AGG = 2;
            } else if (string2.compareTo("MIN") == 0) {
                this.AGG = 3;
            } else if (string2.compareTo("MAX") == 0) {
                this.AGG = 4;
            } else if (string2.compareTo("COUNT") == 0) {
                this.AGG = 5;
                this.resultType = 2;
            } else if (string2.compareTo("LEN") == 0) {
                this.AGG = 6;
                this.resultType = 2;
            } else if (string2.compareTo("CONCAT") == 0) {
                this.AGG = 7;
                this.resultType = 1;
            } else if (string2.compareTo("DISTINCT") == 0) {
                this.AGG = 8;
            } else {
                ToXgene.error("invalid aggregation operator: " + string2, this.node);
            }
        }
        switch (this.AGG) {
            case 1: {
                if (this.DT == 2 || this.DT == 3) break;
                ToXgene.error("in query " + string + "\n SUM() cannot be applied to " + "non-numerical values", this.node);
                break;
            }
            case 2: {
                if (this.DT == 2 || this.DT == 3) break;
                ToXgene.error("in query " + string + "\n AVG() cannot be applied to " + "non-numerical values", this.node);
                break;
            }
            case 7: {
                if (this.DT == 1) break;
                ToXgene.explain("input argument of CONCAT() not STRING in " + string + "\n\tcasting values to STRING");
                break;
            }
            case 6: {
                if (this.DT == 1) break;
                ToXgene.explain("input argument of LEN() not STRING in " + string + "\n\tcasting values to STRING");
            }
        }
    }

    public String relativePath() {
        return this.relativePath;
    }

    public String path() {
        return this.path;
    }

    public String scanName() {
        return this.scanName;
    }

    public void setScan(ToxScan toxScan) {
        this.scan = toxScan;
    }

    public int expressionType() {
        return this.resultType;
    }

    public String expression() {
        return this.expression;
    }

    public void stale() {
        this.fresh = false;
    }

    public boolean fresh() {
        return this.fresh;
    }

    public int getQtty() {
        if (!this.fresh) {
            this.evaluate();
        }
        if (this.AGG == 0) {
            return this.result.size();
        }
        return 1;
    }

    public String absolutePath() {
        return this.absolutePath;
    }

    public Vector evaluateSCAN() {
        if (this.mode == 2) {
            if (!this.fresh) {
                ToxListElement toxListElement = this.scan.refresh();
                if (this.copy_literal) {
                    this.result = new ToxVector(1);
                    this.result.add(toxListElement);
                } else {
                    this.result = this.list.query(toxListElement, this.path);
                }
                this.fresh = true;
            }
        } else {
            this.result = this.list.query(this.path);
        }
        return this.result;
    }

    public Vector evaluateSCAN(ToxListElement toxListElement) {
        return this.list.query(toxListElement, this.path);
    }

    public Vector evaluate() {
        switch (this.mode) {
            case 2: {
                if (this.fresh) break;
                ToxListElement toxListElement = this.scan.refresh();
                if (this.copy_literal) {
                    this.result = new ToxVector(1);
                    this.result.add(toxListElement.getContent());
                    break;
                }
                if (this.copy_tag) {
                    this.result = new ToxVector(1);
                    this.result.add(toxListElement.getTagName());
                    break;
                }
                this.result = this.evaluate(toxListElement, this.path);
                this.fresh = true;
                break;
            }
            case 1: {
                this.result = this.list.query(this.path);
            }
        }
        return this.result;
    }

    public Vector evaluateWHERE() {
        return null;
    }

    public Vector evaluate(ToxListElement toxListElement) {
        return this.evaluate(toxListElement, this.path);
    }

    private Vector evaluate(ToxListElement toxListElement, String string) {
        ToxVector toxVector = this.list.query(toxListElement, string);
        int n = toxVector == null ? 0 : toxVector.size();
        ToxVector toxVector2 = new ToxVector(n);
        try {
            int n2 = 0;
            while (n2 < n) {
                toxVector2.add(((ToxListElement)toxVector.get(n2)).getContent());
                ++n2;
            }
        }
        catch (ToxListElementException toxListElementException) {
            ToXgene.error("query [" + string + "] returns no literals.", this.node);
        }
        return this.process(toxVector2);
    }

    private Vector process(Vector vector) {
        Vector<String> vector2 = null;
        switch (this.AGG) {
            case 1: {
                vector2 = new Vector<String>(1);
                switch (this.DT) {
                    case 2: {
                        long l = 0L;
                        int n = 0;
                        while (n < vector.size()) {
                            l += Long.parseLong((String)vector.get(n));
                            ++n;
                        }
                        vector2.add(Long.toString(l));
                        break;
                    }
                    case 3: {
                        double d = 0.0;
                        int n = 0;
                        while (n < vector.size()) {
                            d += Double.parseDouble((String)vector.get(n));
                            ++n;
                        }
                        vector2.add(Double.toString(d));
                    }
                }
                break;
            }
            case 2: {
                vector2 = new Vector(1);
                switch (this.DT) {
                    case 2: {
                        long l = 0L;
                        int n = 0;
                        while (n < vector.size()) {
                            l += Long.parseLong((String)vector.get(n));
                            ++n;
                        }
                        vector2.add(Long.toString(Math.round(l / (long)vector.size())));
                        break;
                    }
                    case 3: {
                        double d = 0.0;
                        int n = 0;
                        while (n < vector.size()) {
                            d += Double.parseDouble((String)vector.get(n));
                            ++n;
                        }
                        vector2.add(Double.toString(d / (double)vector.size()));
                    }
                }
                break;
            }
            case 3: {
                vector2 = new Vector(1);
                switch (this.DT) {
                    case 2: {
                        long l = Long.parseLong((String)vector.get(0));
                        int n = 1;
                        while (n < vector.size()) {
                            long l2 = Long.parseLong((String)vector.get(n));
                            if (l2 < l) {
                                l = l2;
                            }
                            ++n;
                        }
                        vector2.add(Long.toString(l));
                        break;
                    }
                    case 3: {
                        double d = Double.parseDouble((String)vector.get(0));
                        int n = 1;
                        while (n < vector.size()) {
                            double d2 = Double.parseDouble((String)vector.get(n));
                            if (d2 < d) {
                                d = d2;
                            }
                            ++n;
                        }
                        vector2.add(Double.toString(d));
                        break;
                    }
                    case 4: {
                        Date date = Date.parseDate((String)vector.get(0));
                        int n = 1;
                        while (n < vector.size()) {
                            Date date2 = Date.parseDate((String)vector.get(n));
                            if (date2.before(date)) {
                                date = date2;
                            }
                            ++n;
                        }
                        vector2.add(Date.toString(date));
                        break;
                    }
                    case 1: {
                        String string = (String)vector.get(0);
                        int n = 1;
                        while (n < vector.size()) {
                            String string2 = (String)vector.get(n);
                            if (string2.compareTo(string) < 0) {
                                string = string2;
                            }
                            ++n;
                        }
                        vector2.add(string);
                    }
                }
                break;
            }
            case 4: {
                vector2 = new Vector(1);
                switch (this.DT) {
                    case 2: {
                        long l = Long.parseLong((String)vector.get(0));
                        int n = 1;
                        while (n < vector.size()) {
                            long l3 = Long.parseLong((String)vector.get(n));
                            if (l3 > l) {
                                l = l3;
                            }
                            ++n;
                        }
                        vector2.add(Long.toString(l));
                        break;
                    }
                    case 3: {
                        double d = Double.parseDouble((String)vector.get(0));
                        vector2 = new Vector(1);
                        int n = 1;
                        while (n < vector.size()) {
                            double d3 = Double.parseDouble((String)vector.get(n));
                            if (d3 > d) {
                                d = d3;
                            }
                            ++n;
                        }
                        vector2.add(Double.toString(d));
                        break;
                    }
                    case 4: {
                        Date date = Date.parseDate((String)vector.get(0));
                        int n = 1;
                        while (n < vector.size()) {
                            Date date3 = Date.parseDate((String)vector.get(n));
                            if (date3.after(date)) {
                                date = date3;
                            }
                            ++n;
                        }
                        vector2.add(Date.toString(date));
                        break;
                    }
                    case 1: {
                        String string = (String)vector.get(0);
                        int n = 1;
                        while (n < vector.size()) {
                            String string3 = (String)vector.get(n);
                            if (string3.compareTo(string) > 0) {
                                string = string3;
                            }
                            ++n;
                        }
                        vector2.add(string);
                    }
                }
                break;
            }
            case 5: {
                vector2 = new Vector(1);
                vector2.add(Integer.toString(vector.size()));
                break;
            }
            case 6: {
                if (vector.size() > 1) {
                    ToXgene.error("cannot apply LEN() over a set of strings", this.node);
                }
                vector2 = new Vector(1);
                if (vector.size() == 0) {
                    vector2.add("0");
                }
                int n = ((String)vector.get(0)).length();
                vector2.add(Integer.toString(n));
                break;
            }
            case 7: {
                vector2 = new Vector(1);
                String string = "";
                int n = 0;
                while (n < vector.size()) {
                    string = string + (String)vector.get(n);
                    ++n;
                }
                vector2.add(string);
                break;
            }
            case 8: {
                vector2 = new Vector(vector.size());
                Vector<String> vector3 = new Vector<String>(vector.size());
                int n = 0;
                while (n < vector.size()) {
                    String string = (String)vector.get(n);
                    int n2 = Collections.binarySearch(vector3, string);
                    if (n2 < 0) {
                        vector3.add(-1 - n2, string);
                        vector2.add(string);
                    }
                    ++n;
                }
                break;
            }
            default: {
                vector2 = vector;
            }
        }
        return vector2;
    }
}

