/*
 * Decompiled with CFR 0.152.
 */
package genes.trees;

import genes.Gene;
import genes.lists.ToxListElement;
import genes.literals.LiteralGene;
import genes.trees.Expression;
import genes.trees.ToxScan;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Vector;
import toxgene.ToXgene;
import util.KeyNotFoundException;

public class GeneInstance
implements Expression {
    private Gene gene;
    private String expression;
    private ByteArrayOutputStream temp = new ByteArrayOutputStream();
    private PrintStream stream = new PrintStream(this.temp);
    private Vector value = new Vector(1);
    private int type = -1;

    public GeneInstance(String string) {
        this.value.add("0");
        try {
            this.gene = (Gene)ToXgene.simpleTypes.get(string);
            String string2 = this.gene instanceof ToxScan ? ((ToxScan)this.gene).getType() : ((LiteralGene)this.gene).getType();
            if (string2.compareTo("string") == 0) {
                this.type = 1;
            } else if (string2.compareTo("integer") == 0) {
                this.type = 2;
            } else if (string2.compareTo("real") == 0) {
                this.type = 3;
            } else if (string2.compareTo("date") == 0) {
                this.type = 4;
            } else {
                ToXgene.error("literal gene of complex type: ~" + string);
            }
        }
        catch (KeyNotFoundException keyNotFoundException) {
            ToXgene.error("cannot find simpleType \"" + string + "\" definition");
        }
        this.expression = "~" + string;
    }

    public Vector evaluate() {
        this.gene.generate(this.stream);
        this.value.setElementAt(this.temp.toString(), 0);
        this.temp.reset();
        return this.value;
    }

    public Vector evaluate(ToxListElement toxListElement) {
        return this.evaluate();
    }

    public int expressionType() {
        return this.type;
    }

    public int getQtty() {
        return 1;
    }

    public String expression() {
        return this.expression;
    }
}

