/*
 * Decompiled with CFR 0.152.
 */
package genes.trees;

import genes.lists.ToxList;
import genes.trees.BinaryExpression;
import genes.trees.Constant;
import genes.trees.Expression;
import genes.trees.GeneInstance;
import genes.trees.Query;
import genes.trees.ToxScan;
import org.w3c.dom.Node;
import toxgene.ToXgene;

public abstract class ExpressionParser {
    private static final int SCAN = 1;
    private static final int LIST = 2;
    private static int mode;
    private static ToxList list;
    private static ToxScan scan;
    private static String prefix;
    private static Node node;

    public static Expression parse(String string, ToxScan toxScan, Node node) {
        mode = 1;
        scan = toxScan;
        prefix = null;
        ExpressionParser.node = node;
        Expression expression = ExpressionParser.parse(ExpressionParser.preprocess(string));
        ToXgene.explain("parsed expression: " + expression.expression());
        return expression;
    }

    public static Expression parse(String string, ToxScan toxScan, String string2, Node node) {
        mode = 1;
        scan = toxScan;
        prefix = string2;
        ExpressionParser.node = node;
        Expression expression = ExpressionParser.parse(ExpressionParser.preprocess(string));
        ToXgene.explain("parsed expression: " + expression.expression());
        return expression;
    }

    public static Expression parse(String string, ToxList toxList, String string2, Node node) {
        mode = 2;
        list = toxList;
        prefix = string2;
        ExpressionParser.node = node;
        Expression expression = ExpressionParser.parse(ExpressionParser.preprocess(string));
        ToXgene.explain("parsed expression: " + expression.expression());
        return expression;
    }

    private static Expression parse(String string) {
        int n = string.length();
        if (n == 0) {
            ToXgene.error("invalid tox-query! no expression provided", node);
        }
        int n2 = n - 1;
        while (n2 >= 0) {
            int n3;
            char c = string.charAt(n2);
            switch (c) {
                case ')': {
                    int n4;
                    if (n2 < n - 1) {
                        ToXgene.error("cannot parse expression \"" + string + "\".\n" + "Invalid token \"" + string.substring(n2) + "\" after " + string.substring(0, n2 + 1), node);
                    }
                    if ((n4 = ExpressionParser.getBlockStart(string.substring(0, n2))) == -1) {
                        ToXgene.error("cannot parse expression \"" + string + "\".\n" + "Unmatching ')' after " + string.substring(0, n2 + 1), node);
                    }
                    if (n4 > 0) {
                        n3 = ExpressionParser.getOperator(string.charAt(n4 - 1));
                        if (n3 != -1) {
                            Expression expression = ExpressionParser.parse(string.substring(0, n4 - 1));
                            Expression expression2 = ExpressionParser.parse(string.substring(n4 + 1, n2));
                            return new BinaryExpression(expression, expression2, n3);
                        }
                        ToXgene.error("cannot parse expression \"" + string + "\".\n" + "Operator required after " + string.substring(0, n4 - 1), node);
                    } else {
                        return ExpressionParser.parse(string.substring(1, n2));
                    }
                }
                case '\'': {
                    int n4;
                    if (n2 < n - 1) {
                        ToXgene.error("cannot parse expression \"" + string + "\".\n" + "Invalid token \"" + string.substring(n2) + "\" after " + string.substring(0, n2 + 1), node);
                    }
                    if ((n4 = ExpressionParser.getConstantStart(string.substring(0, n2))) == -1) {
                        ToXgene.error("cannot parse expression \"" + string + "\".\n" + "Invalid constant " + string, node);
                    }
                    if (n4 > 0) {
                        n3 = ExpressionParser.getOperator(string.charAt(n4 - 1));
                        if (n3 != -1) {
                            Expression expression = ExpressionParser.parse(string.substring(0, n4 - 1));
                            Constant constant = new Constant(string.substring(n4, n2 + 1));
                            return new BinaryExpression(expression, constant, n3);
                        }
                        ToXgene.error("cannot parse expression \"" + string + "\".\n" + "Operator required after " + string.substring(0, n4), node);
                    } else {
                        return new Constant(string.substring(n4, n2 + 1));
                    }
                }
                case ']': {
                    int n4;
                    if (n2 < n - 1) {
                        ToXgene.error("cannot parse expression \"" + string + "\".\n" + "Invalid token \"" + string.substring(n2) + "\" after ']'", node);
                    }
                    if ((n4 = ExpressionParser.getQueryStart(string.substring(0, n2))) == -1) {
                        ToXgene.error("cannot parse expression \"" + string + "\"\n" + "Unmatching ']' after " + string.substring(0, n2), node);
                    }
                    if (n4 > 0) {
                        n3 = ExpressionParser.getOperator(string.charAt(n4 - 1));
                        if (n3 != -1) {
                            Expression expression = ExpressionParser.parse(string.substring(0, n4 - 1));
                            Query query = mode == 2 ? new Query(string.substring(n4, n2 + 1), list, prefix, node) : new Query(string.substring(n4, n2 + 1), scan, prefix, node);
                            return new BinaryExpression(expression, query, n3);
                        }
                        ToXgene.error("cannot parse expression \"" + string + "\".\n" + "Operator required after " + string.substring(0, n4), node);
                    } else {
                        if (mode == 2) {
                            return new Query(string, list, prefix, node);
                        }
                        return new Query(string, scan, prefix, node);
                    }
                }
                case '(': {
                    ToXgene.error("cannot parse expression \"" + string + "\".\n" + "Unmatching '(' after " + string.substring(0, n2), node);
                }
                case '[': {
                    ToXgene.error("cannot parse expression \"" + string + "\".\n" + "Unmatching '[' after " + string.substring(0, n2), node);
                }
            }
            n3 = ExpressionParser.getOperator(c);
            if (n3 != -1) {
                if (n2 == n) {
                    ToXgene.error("cannot parse expression \"" + string + "\".\n" + "Operator required after " + string, node);
                }
                Expression expression = ExpressionParser.parse(string.substring(0, n2));
                Expression expression3 = ExpressionParser.parse(string.substring(n2 + 1));
                return new BinaryExpression(expression, expression3, n3);
            }
            --n2;
        }
        if (string.charAt(0) == '~') {
            return new GeneInstance(string.substring(1));
        }
        return new Constant(string);
    }

    private static int getBlockStart(String string) {
        int n = 0;
        int n2 = string.length();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            char c = string.charAt(n3);
            if (c == ')') {
                ++n;
            }
            if (c == '(') {
                if (n == 0) {
                    return n3;
                }
                --n;
            }
            --n3;
        }
        return -1;
    }

    private static int getBlockEnd(String string) {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (c == '(') {
                ++n;
            }
            if (c == ')') {
                if (n == 0) {
                    return n3;
                }
                --n;
            }
            ++n3;
        }
        return -1;
    }

    private static int getConstantStart(String string) {
        int n = string.length();
        int n2 = n - 1;
        while (n2 >= 0) {
            char c = string.charAt(n2);
            if (c == '\'') {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    private static int getQueryStart(String string) {
        int n = string.length();
        int n2 = n - 1;
        while (n2 >= 0) {
            char c = string.charAt(n2);
            if (c == '[') {
                if (n2 == 0) {
                    return 0;
                }
                if (n2 < 3 || ExpressionParser.getOperator(string.charAt(n2 - 1)) != -1) {
                    return n2;
                }
                if (n2 < 5 || ExpressionParser.getOperator(string.charAt(n2 - 4)) != -1) {
                    return n2 - 3;
                }
                if (n2 < 6 || ExpressionParser.getOperator(string.charAt(n2 - 6)) != -1) {
                    return n2 - 5;
                }
                if (n2 < 8 || ExpressionParser.getOperator(string.charAt(n2 - 7)) != -1) {
                    return n2 - 6;
                }
                return n2 - 8;
            }
            --n2;
        }
        return -1;
    }

    private static int getOperator(char c) {
        switch (c) {
            case '+': {
                return 1;
            }
            case '-': {
                return 2;
            }
            case '*': {
                return 3;
            }
            case '/': {
                return 4;
            }
            case '%': {
                return 5;
            }
            case '#': {
                return 6;
            }
        }
        return -1;
    }

    private static String preprocess(String string) {
        int n = string.length();
        String string2 = new String(string);
        int n2 = n - 1;
        while (n2 >= 0) {
            String string3;
            String string4;
            int n3;
            char c = string2.charAt(n2);
            if (c == '\'') {
                n2 = ExpressionParser.getConstantStart(string.substring(0, n2));
            }
            if (c == ']') {
                n2 = ExpressionParser.getQueryStart(string.substring(0, n2));
            }
            if (c == ')') {
                n3 = ExpressionParser.getBlockStart(string2.substring(0, n2));
                String string5 = string2.substring(0, n3);
                string4 = string2.substring(n2 + 1);
                string3 = string2.substring(n3 + 1, n2);
                string2 = string5 + "(" + ExpressionParser.preprocess(string3) + ")" + string4;
                n = string2.length();
                n2 = n3;
            } else if (c == '/' || c == '*') {
                String string6;
                n3 = ExpressionParser.getExpressionStart(string2.substring(0, n2));
                int n4 = n2 + ExpressionParser.getExpressionEnd(string2.substring(n2 + 1));
                string4 = string2.substring(n3, n2);
                string3 = string2.substring(n2 + 1, n4 + 1);
                if (n3 == 0) {
                    if (n4 == n - 1) {
                        string2 = ExpressionParser.preprocess(string4) + c + string3;
                    } else {
                        string6 = string2.substring(n4 + 1);
                        string2 = ExpressionParser.preprocess(string4) + c + string3 + string6;
                    }
                } else {
                    string6 = string2.substring(0, n3);
                    if (n4 == n - 1) {
                        string2 = string6 + "(" + ExpressionParser.preprocess(string4) + c + string3 + ")";
                    } else {
                        String string7 = string2.substring(n4 + 1);
                        string2 = string6 + "(" + ExpressionParser.preprocess(string4) + c + string3 + ")" + string7;
                    }
                }
                n = string2.length();
                n2 = n3;
            }
            --n2;
        }
        return string2;
    }

    private static int getExpressionStart(String string) {
        int n = string.length();
        int n2 = n - 1;
        while (n2 >= 0) {
            char c = string.charAt(n2);
            switch (c) {
                case ')': {
                    int n3;
                    if (n2 < n - 1) {
                        ToXgene.error("cannot parse expression \"" + string + "\".\n" + "Invalid token \"" + string.substring(n2) + "\" after " + string.substring(0, n2 + 1), node);
                    }
                    if ((n3 = ExpressionParser.getBlockStart(string.substring(0, n2))) == -1) {
                        ToXgene.error("cannot parse expression \"" + string + "\".\n" + "Unmatching ')' after " + string.substring(0, n2), node);
                    }
                    return n3;
                }
                case ']': {
                    int n4;
                    if (n2 < n - 1) {
                        ToXgene.error("cannot parse expression \"" + string + "\".\n" + "Invalid token \"" + string.substring(n2) + "\" after " + string.substring(0, n2 + 1), node);
                    }
                    if ((n4 = ExpressionParser.getQueryStart(string.substring(0, n2))) == -1) {
                        ToXgene.error("cannot parse expression \"" + string + "\"\n" + "Unmatching ']' after " + string.substring(0, n2), node);
                    }
                    return n4;
                }
                case '\'': {
                    int n5;
                    if (n2 < n - 1) {
                        ToXgene.error("cannot parse expression \"" + string + "\".\n" + "Invalid token \"" + string.substring(n2) + "\" after " + string.substring(0, n2 + 1), node);
                    }
                    if ((n5 = ExpressionParser.getConstantStart(string.substring(0, n2))) == -1) {
                        ToXgene.error("cannot parse expression \"" + string + "\".\n" + "Invalid constant " + string, node);
                    }
                    return n5;
                }
            }
            if (ExpressionParser.getOperator(c) != -1) {
                return n2 + 1;
            }
            --n2;
        }
        return 0;
    }

    private static int getExpressionEnd(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '(': {
                    int n3;
                    if (n2 > 0) {
                        ToXgene.error("cannot parse expression \"" + string + "\".\n" + "Invalid token \"" + string.substring(n2) + "\" after " + string.substring(0, n2), node);
                    }
                    if ((n3 = ExpressionParser.getBlockEnd(string.substring(n2 + 1))) == -1) {
                        ToXgene.error("cannot parse expression \"" + string + "\".\n" + "Unmatching ')' after " + string.substring(0, n2), node);
                    }
                    return n3 + 2;
                }
                case '[': {
                    int n4 = string.indexOf(93, n2 + 1);
                    if (n4 == -1) {
                        ToXgene.error("cannot parse expression \"" + string + "\"\n" + "Unmatching ']' after " + string.substring(0, n2), node);
                    }
                    return n4 + 1;
                }
                case '\'': {
                    int n5;
                    if (n2 > 0) {
                        ToXgene.error("cannot parse expression \"" + string + "\".\n" + "Invalid token \"" + string.substring(n2) + "\" after " + string.substring(0, n2), node);
                    }
                    if ((n5 = string.indexOf(39, n2 + 1)) == -1) {
                        ToXgene.error("cannot parse expression \"" + string + "\".\n" + "Invalid constant " + string, node);
                    }
                    return n5 + 1;
                }
            }
            if (ExpressionParser.getOperator(c) != -1) {
                return n2;
            }
            ++n2;
        }
        return n;
    }
}

