/*
 * Decompiled with CFR 0.152.
 */
package genes.trees;

import genes.lists.ToxListElement;
import genes.trees.Expression;
import java.io.Serializable;
import java.util.Vector;
import toxgene.ToXgene;
import util.Date;

public class BinaryExpression
implements Expression,
Serializable {
    private Expression operand1;
    private Expression operand2;
    private int operation;
    private int type;
    private int type1;
    private int type2;

    public BinaryExpression(Expression expression, Expression expression2, int n) {
        this.operation = n;
        this.operand1 = expression;
        this.operand2 = expression2;
        this.type1 = this.operand1.expressionType();
        if (this.type1 == -1) {
            ToXgene.error("invalid operand: complex type returned!");
        }
        this.type2 = this.operand2.expressionType();
        if (this.type1 == -1) {
            ToXgene.error("invalid operand: complex type returned!");
        }
        if (n != 6) {
            if (this.type1 == this.type2) {
                this.type = this.type1;
            } else if (this.type1 == 2 && this.type2 == 3 || this.type2 == 2 && this.type1 == 3) {
                this.type = 3;
                if (this.type1 == 2) {
                    ToXgene.explain("casting INTEGER value \"" + this.operand1.expression() + "\" \n\tin \"" + this.expression() + "\" to REAL.");
                }
                if (this.type2 == 2) {
                    ToXgene.explain("casting INTEGER value \"" + this.operand2.expression() + "\" \n\tin \"" + this.expression() + "\" to REAL.");
                }
            } else {
                this.type = this.type1 == 2 && this.type2 == 4 || this.type2 == 2 && this.type1 == 4 ? 4 : 1;
            }
        } else {
            this.type = 1;
        }
    }

    public Vector evaluate() {
        Vector vector = this.operand1.evaluate();
        Vector vector2 = this.operand2.evaluate();
        Vector vector3 = null;
        try {
            vector3 = this.process(vector, vector2);
        }
        catch (ArithmeticException arithmeticException) {
            ToXgene.error(arithmeticException.getMessage() + "\nin expression 1" + this.expression());
        }
        catch (NumberFormatException numberFormatException) {
            ToXgene.error(numberFormatException.getMessage() + "\nin expression 2" + this.expression());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ToXgene.error(exception.getMessage() + "\nin expression 3" + this.expression());
        }
        return vector3;
    }

    public Vector evaluate(ToxListElement toxListElement) {
        Vector vector = this.operand1.evaluate(toxListElement);
        Vector vector2 = this.operand2.evaluate(toxListElement);
        Vector vector3 = null;
        try {
            vector3 = this.process(vector, vector2);
        }
        catch (ArithmeticException arithmeticException) {
            ToXgene.error(arithmeticException.getMessage() + "\nin expression 4" + this.expression());
        }
        catch (NumberFormatException numberFormatException) {
            ToXgene.error(numberFormatException.getMessage() + "\nin expression 5" + this.expression());
        }
        catch (Exception exception) {
            ToXgene.error(exception.getMessage() + "\nin expression 6" + this.expression());
        }
        return vector3;
    }

    public int expressionType() {
        return this.type;
    }

    public String expression() {
        String string = this.operand1.expression();
        String string2 = this.operand2.expression();
        switch (this.operation) {
            case 1: {
                return "(" + string + "+" + string2 + ")";
            }
            case 2: {
                return "(" + string + "-" + string2 + ")";
            }
            case 3: {
                return "(" + string + "*" + string2 + ")";
            }
            case 4: {
                return "(" + string + "/" + string2 + ")";
            }
            case 5: {
                return "(" + string + "%" + string2 + ")";
            }
            case 6: {
                return "(" + string + "#" + string2 + ")";
            }
        }
        return null;
    }

    public int getQtty() {
        return 1;
    }

    private String convert(int n) {
        switch (n) {
            case 1: {
                return "STRING";
            }
            case 2: {
                return "INTEGER";
            }
            case 3: {
                return "REAL";
            }
            case 4: {
                return "DATE";
            }
            case 5: {
                return "COMPLEX";
            }
        }
        return null;
    }

    private Vector process(Vector vector, Vector vector2) {
        Vector<String> vector3 = new Vector<String>(1);
        if (vector.size() != 1 || vector2.size() != 1) {
            ToXgene.error("invalid expression \"" + this.expression() + "\": operands return no values");
        }
        String string = (String)vector.get(0);
        String string2 = (String)vector2.get(0);
        if (this.type1 == this.type2) {
            block0 : switch (this.operation) {
                case 1: {
                    switch (this.type1) {
                        case 2: {
                            vector3.add(Long.toString(Long.parseLong(string) + Long.parseLong(string2)));
                            break block0;
                        }
                        case 3: {
                            vector3.add(Double.toString(Double.parseDouble(string) + Double.parseDouble(string2)));
                            break block0;
                        }
                        case 4: {
                            vector3.add(Date.toString(Date.parseDate(string).add(Date.parseDate(string2))));
                            break block0;
                        }
                    }
                    ToXgene.error("invalid expression \"" + this.expression() + "\": cannot add STRING values");
                    break;
                }
                case 2: {
                    switch (this.type1) {
                        case 2: {
                            vector3.add(Long.toString(Long.parseLong(string) - Long.parseLong(string2)));
                            break block0;
                        }
                        case 3: {
                            vector3.add(Double.toString(Double.parseDouble(string) - Double.parseDouble(string2)));
                            break block0;
                        }
                        case 4: {
                            vector3.add(Date.toString(Date.parseDate(string).sub(Date.parseDate(string2))));
                            break block0;
                        }
                    }
                    ToXgene.error("invalid expression \"" + this.expression() + "\": cannot subtract STRING values");
                    break;
                }
                case 3: {
                    switch (this.type1) {
                        case 2: {
                            vector3.add(Long.toString(Long.parseLong(string) * Long.parseLong(string2)));
                            break block0;
                        }
                        case 3: {
                            vector3.add(Double.toString(Double.parseDouble(string) * Double.parseDouble(string2)));
                            break block0;
                        }
                    }
                    ToXgene.error("invalid expression \"" + this.expression() + "\": cannot multiply non-numerical values");
                    break;
                }
                case 4: {
                    switch (this.type1) {
                        case 2: {
                            vector3.add(Long.toString(Long.parseLong(string) / Long.parseLong(string2)));
                            break block0;
                        }
                        case 3: {
                            vector3.add(Double.toString(Double.parseDouble(string) / Double.parseDouble(string2)));
                            break block0;
                        }
                    }
                    ToXgene.error("invalid expression \"" + this.expression() + "\": cannot divide non numeric values");
                    System.exit(1);
                    break;
                }
                case 5: {
                    switch (this.type1) {
                        case 2: {
                            vector3.add(Long.toString(Long.parseLong(string) % Long.parseLong(string2)));
                            break block0;
                        }
                        case 3: {
                            vector3.add(Double.toString(Double.parseDouble(string) % Double.parseDouble(string2)));
                            break block0;
                        }
                    }
                    ToXgene.error("invalid expression: " + this.expression() + ": MOD does not apply to non numeric values");
                    System.exit(1);
                    break;
                }
                case 6: {
                    vector3.add(string + string2);
                }
            }
        } else {
            boolean bl = false;
            if (this.type1 == 1 || this.type2 == 1) {
                switch (this.operation) {
                    case 6: {
                        vector3.add(string + string2);
                        break;
                    }
                    default: {
                        ToXgene.error("cannot evaluate expression \"" + this.expression() + "\". Mismatching types:\n\t" + this.operand1.expression() + ": " + this.convert(this.operand1.expressionType()) + "\n\t" + this.operand2.expression() + ": " + this.convert(this.operand2.expressionType()));
                    }
                }
                bl = true;
            }
            if (this.type1 == 4 && this.type2 == 2) {
                switch (this.operation) {
                    case 1: {
                        vector3.add(Date.toString(Date.parseDate(string).add(Integer.parseInt(string2))));
                        break;
                    }
                    case 2: {
                        vector3.add(Date.toString(Date.parseDate(string).add(-1 * Integer.parseInt(string2))));
                        break;
                    }
                    case 6: {
                        vector3.add(string + string2);
                        break;
                    }
                    default: {
                        ToXgene.error("cannot evaluate expression \"" + this.expression() + "\". Mismatching types:\n\t" + this.operand1.expression() + ": " + this.convert(this.operand1.expressionType()) + "\n\t" + this.operand2.expression() + ": " + this.convert(this.operand2.expressionType()));
                    }
                }
                bl = true;
            }
            if (this.type2 == 4 && this.type1 == 2) {
                switch (this.operation) {
                    case 1: {
                        vector3.add(Date.toString(Date.parseDate(string2).add(Integer.parseInt(string))));
                        break;
                    }
                    case 2: {
                        vector3.add(Date.toString(Date.parseDate(string2).add(-1 * Integer.parseInt(string))));
                        break;
                    }
                    case 6: {
                        vector3.add(string + string2);
                        break;
                    }
                    default: {
                        ToXgene.error("cannot evaluate expression \"" + this.expression() + "\". Mismatching types:\n\t" + this.operand1.expression() + ": " + this.convert(this.operand1.expressionType()) + "\n\t" + this.operand2.expression() + ": " + this.convert(this.operand2.expressionType()));
                    }
                }
                bl = true;
            }
            if (this.type1 == 2 && this.type2 == 3 || this.type2 == 2 && this.type1 == 3) {
                switch (this.operation) {
                    case 1: {
                        vector3.add(Double.toString(Double.parseDouble(string) + Double.parseDouble(string2)));
                        break;
                    }
                    case 2: {
                        vector3.add(Double.toString(Double.parseDouble(string) - Double.parseDouble(string2)));
                        break;
                    }
                    case 3: {
                        vector3.add(Double.toString(Double.parseDouble(string) * Double.parseDouble(string2)));
                        break;
                    }
                    case 4: {
                        vector3.add(Double.toString(Double.parseDouble(string) / Double.parseDouble(string2)));
                        break;
                    }
                    case 5: {
                        vector3.add(Double.toString(Double.parseDouble(string) % Double.parseDouble(string2)));
                        break;
                    }
                    case 6: {
                        vector3.add(string + string2);
                    }
                }
                bl = true;
            }
            if (!bl) {
                if (this.operation == 6) {
                    vector3.add(string + string2);
                } else {
                    ToXgene.error("cannot evaluate expression \"" + this.expression() + "\". Mismatching types:\n\t" + this.operand1.expression() + ": " + this.convert(this.operand1.expressionType()) + "\n\t" + this.operand2.expression() + ": " + this.convert(this.operand2.expressionType()));
                }
            }
        }
        return vector3;
    }
}

