/*
 * Decompiled with CFR 0.152.
 */
package genes.literals;

import genes.literals.LiteralGene;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Random;
import random.ToxRandom;
import toxgene.ToXgene;

public class ToxString
extends LiteralGene
implements Serializable {
    public static final int PATTERN = 1;
    public static final int WORD = 2;
    public static final int SENTENCE = 3;
    public static final int TEXT = 4;
    public static final int GIBBERISH = 5;
    private String pattern;
    private int type;
    private ToxRandom lengthGene;
    private Random pick;
    private String[] nouns = new String[]{"foxes", "ideas", "theodolites", "pinto", "beans", "instructions", "dependencies", "excuses", "platelets", "asymptotes", "courts", "dolphins", "multipliers", "sauternes", "warthogs", "frets", "dinos", "attainments", "somas", "Tiresias", "patterns", "forges", "braids", "hockey", "players", "frays", "warhorses", "dugouts", "notornis", "epitaphs", "pearls", "tithes", "waters", "orbits", "gifts", "sheaves", "depths", "sentiments", "decoys", "realms", "pains", "grouches", "escapades"};
    private int nNouns = this.nouns.length;
    private String[] verbs = new String[]{"sleep", "wake", "are", "cajole", "haggle", "nag", "use", "boost", "affix", "detect", "integrate", "maintain", "nod", "was", "lose", "sublate", "solve", "thrash", "promise", "engage", "hinder", "print", "x-ray", "breach", "eat", "grow", "impress", "mold", "poach", "serve", "run", "dazzle", "snooze", "doze", "unwind", "kindle", "play", "hang", "belive", "doubt"};
    private int nVerbs = this.verbs.length;
    private String[] adjectives = new String[]{"furious", "sly", "careful", "blithe", "quick", "fluffy", "slow", "quiet", "ruthless", "thin", "close", "dogged", "daring", "brave", "stealthy", "permanent", "enticing", "idle", "busy", "regular", "final", "ironic", "even", "bold", "silent"};
    private int nAdjectives = this.adjectives.length;
    private String[] adverbs = new String[]{"sometimes", "always", "never", "furiously", "slyly", "carefully", "blithely", "quickly", "fluffily", "slowly", "quietly", "ruthlessly", "thinly", "closely", "doggedly", "daringly", "bravely", "stealthly", "permanently", "enticingly", "idly", "busily", "regularly", "finally", "ironically", "evenly", "boldly", "silently"};
    private int nAdverbs = this.adverbs.length;
    private String[] prepositions = new String[]{"about", "above", "according to", "across", "after", "against", "along", "alongside of", "among", "around", "at", "atop", "before", "behind", "beneath", "beside", "besides", "between", "beyond", "bye", "despite", "during", "except", "for", "from", "in place of", "inside", "instead of", "into", "near", "of", "on", "outside", "over", "past", "since", "through", "throughout", "to", "toward", "under", "until", "up", "upon", "without", "with", "within"};
    private int nPrepositions = this.prepositions.length;
    private String[] auxiliaries = new String[]{"do", "may", "might", "shall", "will", "would", "can", "could", "should", "ought to", "must", "will have to", "shall have to", "could have to", "should have to", "must have to", "need to", "try to"};
    private int nAuxiliaries = this.auxiliaries.length;
    private String[] terminators = new String[]{".", ";", ":", "?", "!", "--"};
    private int nTerminators = this.terminators.length;

    public ToxString(String string) {
        this.pattern = string;
        this.type = 1;
        this.pick = new Random(ToXgene.seedGenerator.nextInt());
    }

    public ToxString(String string, ToxRandom toxRandom) {
        this.lengthGene = toxRandom;
        this.pick = new Random(ToXgene.seedGenerator.nextInt());
        if (string.compareTo("word") == 0) {
            this.type = 2;
        } else if (string.compareTo("sentence") == 0) {
            this.type = 3;
        } else if (string.compareTo("text") == 0) {
            this.type = 4;
        } else if (string.compareTo("gibberish") == 0) {
            this.type = 5;
        } else {
            System.out.println("Error: Invalid type definition for ToxString.");
            System.exit(-1);
        }
    }

    public ToxString(ToxRandom toxRandom) {
        this.lengthGene = toxRandom;
        this.type = 5;
        this.pick = new Random(ToXgene.seedGenerator.nextInt());
    }

    public String baseType() {
        return "string";
    }

    public void generate(PrintStream printStream) {
        switch (this.type) {
            case 1: {
                printStream.print(this.ToxStringPattern());
                break;
            }
            case 2: {
                String string;
                int n = (int)this.lengthGene.nextInt();
                while ((string = this.ToxStringWord()).length() > n) {
                }
                printStream.print(string);
                break;
            }
            case 3: {
                String string;
                int n = (int)this.lengthGene.nextInt();
                while ((string = this.ToxStringSentence()).length() > n) {
                }
                printStream.print(string);
                break;
            }
            case 4: {
                printStream.print(this.ToxStringText());
                break;
            }
            case 5: {
                printStream.print(this.gibberish());
            }
        }
    }

    private String ToxStringPattern() {
        return this.processPattern(this.pattern);
    }

    private String processPattern(String string) {
        String string2 = new String();
        String string3 = new String();
        int n = 32;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            char c = string.charAt(n3);
            if (c == '[') {
                n8 = -1;
                n7 = 0;
                int n9 = n3 + 1;
                while (n9 < n2) {
                    n6 = string.charAt(n9);
                    if (n6 == 93) {
                        if (n7 == 0) {
                            n8 = n9;
                            n9 = n2;
                        } else {
                            --n7;
                        }
                    } else if (n6 == 91) {
                        ++n7;
                    }
                    ++n9;
                }
                if (n8 == -1) {
                    System.out.println("***** Invalid pattern definition! 1");
                    System.exit(1);
                }
                string3 = string.substring(n3 + 1, n8);
                n3 = n8;
                n5 = 1;
                if (n3 < n2 - 1 && string.charAt(n3 + 1) == '{') {
                    n4 = string.indexOf("}", n3);
                    if (n4 == -1) {
                        System.out.println("***** Invalid pattern definition! 2");
                        System.exit(1);
                    }
                    n5 = Integer.valueOf(string.substring(n3 + 2, n4));
                    n3 = n4;
                }
                int n10 = 0;
                while (n10 < n5) {
                    string2 = string2 + this.processPattern(string3);
                    ++n10;
                }
            } else if (c == '{') {
                n4 = string.indexOf("}", n3);
                if (n4 == -1) {
                    System.out.println("***** Invalid pattern definition! 3");
                    System.exit(1);
                }
                n3 = n4;
            } else {
                n5 = 1;
                if (n3 < n2 - 1 && string.charAt(n3 + 1) == '{') {
                    n4 = string.indexOf("}", n3);
                    if (n4 == -1) {
                        System.out.println("***** Invalid pattern definition! 4");
                        System.exit(1);
                    }
                    n5 = Integer.valueOf(string.substring(n3 + 2, n4));
                    n3 = n4;
                    n8 = 0;
                    while (n8 < n5) {
                        string2 = string2 + c;
                        ++n8;
                    }
                } else if (n3 < n2 - 1 && string.charAt(n3 + 1) == '-') {
                    try {
                        n = string.charAt(n3 + 2);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        System.out.println("***** Invalid pattern definition! 5");
                        System.exit(1);
                    }
                    n8 = c;
                    n7 = n;
                    n6 = n8 + this.pick.nextInt(n7 - n8 + 1);
                    string2 = string2 + new Character((char)n6);
                    n3 += 2;
                } else {
                    string2 = string2 + c;
                }
            }
            ++n3;
        }
        return string2;
    }

    private String ToxStringWord() {
        int n = this.nNouns + this.nAdjectives + this.nAdverbs;
        float f = this.pick.nextFloat();
        if (f <= (float)this.nNouns / (float)n) {
            return this.nouns[this.pick.nextInt(this.nNouns)];
        }
        if (f <= (float)(this.nNouns + this.nAdjectives) / (float)n) {
            return this.adjectives[this.pick.nextInt(this.nAdjectives)];
        }
        return this.adverbs[this.pick.nextInt(this.nAdverbs)];
    }

    private String ToxStringSentence() {
        int n = this.pick.nextInt(5);
        int n2 = this.pick.nextInt(this.nTerminators);
        switch (n) {
            case 0: {
                return this.nounPhrase().concat(" ").concat(this.verbPhrase()).concat(this.terminators[n2]);
            }
            case 1: {
                return this.nounPhrase().concat(" ").concat(this.verbPhrase()).concat(" ").concat(this.prepositionalPhrase()).concat(this.terminators[n2]);
            }
            case 2: {
                return this.nounPhrase().concat(" ").concat(this.verbPhrase()).concat(" ").concat(this.nounPhrase()).concat(this.terminators[n2]);
            }
            case 3: {
                return this.nounPhrase().concat(" ").concat(this.prepositionalPhrase()).concat(" ").concat(this.verbPhrase()).concat(" ").concat(this.nounPhrase()).concat(this.terminators[n2]);
            }
            case 4: {
                return this.nounPhrase().concat(" ").concat(this.prepositionalPhrase()).concat(" ").concat(this.verbPhrase()).concat(" ").concat(this.prepositionalPhrase()).concat(this.terminators[n2]);
            }
        }
        return null;
    }

    private String ToxStringText() {
        int n = (int)this.lengthGene.nextInt();
        String string = new String();
        while ((string = string.concat(this.ToxStringSentence())).length() <= n) {
        }
        return string.substring(0, n);
    }

    private String nounPhrase() {
        int n = this.pick.nextInt(4);
        switch (n) {
            case 0: {
                return this.nouns[this.pick.nextInt(this.nNouns)];
            }
            case 1: {
                return this.adjectives[this.pick.nextInt(this.nAdjectives)].concat(" ").concat(this.nouns[this.pick.nextInt(this.nNouns)]);
            }
            case 2: {
                return this.adjectives[this.pick.nextInt(this.nAdjectives)].concat(", ").concat(this.adjectives[this.pick.nextInt(this.nAdjectives)]).concat(" ").concat(this.nouns[this.pick.nextInt(this.nNouns)]);
            }
            case 3: {
                return this.adverbs[this.pick.nextInt(this.nAdverbs)].concat(" ").concat(this.adjectives[this.pick.nextInt(this.nAdjectives)]).concat(" ").concat(this.nouns[this.pick.nextInt(this.nNouns)]);
            }
        }
        return null;
    }

    private String verbPhrase() {
        int n = this.pick.nextInt(4);
        switch (n) {
            case 0: {
                return this.verbs[this.pick.nextInt(this.nVerbs)];
            }
            case 1: {
                return this.auxiliaries[this.pick.nextInt(this.nAuxiliaries)].concat(" ").concat(this.verbs[this.pick.nextInt(this.nVerbs)]);
            }
            case 2: {
                return this.verbs[this.pick.nextInt(this.nVerbs)].concat(" ").concat(this.adverbs[this.pick.nextInt(this.nAdverbs)]);
            }
            case 3: {
                return this.auxiliaries[this.pick.nextInt(this.nAuxiliaries)].concat(" ").concat(this.verbs[this.pick.nextInt(this.nVerbs)]).concat(" ").concat(this.adverbs[this.pick.nextInt(this.nAdverbs)]);
            }
        }
        return null;
    }

    private String prepositionalPhrase() {
        int n = this.pick.nextInt(this.nPrepositions);
        return this.prepositions[n].concat(" the ").concat(this.nounPhrase());
    }

    private String gibberish() {
        char[] cArray = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '!', '@', '#', '$', '^', '*', '(', ')', '_', '-', '=', '+', '{', '}', '[', ']', '|', ':', ';', ',', '.', '?', '/', '~', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        String string = new String();
        int n = cArray.length;
        int n2 = (int)this.lengthGene.nextInt();
        int n3 = 0;
        while (n3 < n2) {
            char c = cArray[this.pick.nextInt(n)];
            string = string.concat(String.valueOf(c));
            ++n3;
        }
        return string;
    }

    public void resetRandomGen() {
        if (this.lengthGene != null) {
            this.lengthGene.resetRandomGen();
        }
        this.pick.setSeed(ToXgene.seedGenerator.nextInt());
    }
}

