/*
 * Decompiled with CFR 0.152.
 */
package genes.literals;

import genes.literals.LiteralGene;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import random.ToxRandom;
import toxgene.ToXgene;

public class ToxNumber
extends LiteralGene
implements Serializable {
    public static final int INTEGER = 1;
    public static final int REAL = 2;
    private int type;
    private String pattern;
    private float minInclusive;
    private float maxInclusive;
    private float current;
    private float increment;
    private boolean sequential;
    private boolean decreasing = false;
    private ToxRandom rand;
    private DecimalFormat nf;

    public ToxNumber(int n, float f, float f2, boolean bl, String string, ToxRandom toxRandom) {
        this.sequential = bl;
        this.type = n;
        this.minInclusive = f;
        this.maxInclusive = f2;
        if (string.length() != 0) {
            this.pattern = string;
        } else {
            string = n == 1 ? "0;-0" : "0.#;-0.#";
        }
        this.rand = toxRandom;
        if (bl) {
            this.increment = toxRandom.nextInt();
            if (this.increment < 0.0f) {
                this.current = this.maxInclusive;
                this.decreasing = true;
            } else {
                this.current = this.minInclusive;
            }
        }
        this.nf = new DecimalFormat(string);
    }

    public String baseType() {
        if (this.type == 1) {
            return "integer";
        }
        return "real";
    }

    public void generate(PrintStream printStream) {
        switch (this.type) {
            case 1: {
                long l;
                if (this.sequential) {
                    l = (long)this.current;
                    this.current += this.increment;
                    if (l < (long)this.minInclusive || l > (long)this.maxInclusive) {
                        ToXgene.error("value \"" + l + "\" out of interval [" + this.minInclusive + "," + this.maxInclusive + "] in sequential tox-number.");
                    }
                } else {
                    l = this.rand.nextInt();
                }
                printStream.print(this.nf.format(l));
                break;
            }
            case 2: {
                float f;
                if (this.sequential) {
                    f = this.current;
                    this.current += this.increment;
                    if (f < this.minInclusive || f > this.maxInclusive) {
                        ToXgene.error("value \"" + f + "\" out of interval [" + this.minInclusive + "," + this.maxInclusive + "] in sequential tox-number.");
                    }
                } else {
                    f = this.rand.nextFloat();
                }
                printStream.print(this.nf.format(f));
            }
        }
    }

    public void reset() {
        if (this.sequential) {
            this.current = this.increment > 0.0f ? this.minInclusive : this.maxInclusive;
        }
    }

    public void resetRandomGen() {
        this.rand.resetRandomGen();
    }
}

