/*
 * Decompiled with CFR 0.152.
 */
package genes.literals;

import genes.VarQttyGene;
import genes.lists.ListGene;
import genes.lists.ToxList;
import genes.lists.ToxListElement;
import genes.literals.LiteralGene;
import genes.trees.Expression;
import genes.trees.Query;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Vector;
import toxgene.ToXgene;
import util.Date;

public class ToxGet
extends LiteralGene
implements ListGene,
VarQttyGene,
Serializable {
    private Expression expression;
    private int type;
    private int min_qtty;
    private int max_qtty;
    private int qtty;
    private int current;
    private Vector values;
    private boolean unique;
    private Vector output;
    private boolean format;
    private DecimalFormat decimalFormat;
    private SimpleDateFormat dateFormat;

    public ToxGet(Expression expression, int n, int n2, String string) {
        this.min_qtty = n;
        this.max_qtty = n2;
        this.expression = expression;
        this.type = expression.expressionType();
        if (string.length() != 0) {
            this.format = true;
            if (this.type == 2 || this.type == 3) {
                this.decimalFormat = new DecimalFormat(string);
            } else if (this.type == 4) {
                this.dateFormat = new SimpleDateFormat(string);
            }
        } else {
            this.format = false;
        }
    }

    public void generate(PrintStream printStream) {
        if (this.type == 5) {
            Vector vector = ((Query)this.expression).evaluateSCAN();
            int n = vector == null ? 0 : vector.size();
            int n2 = 0;
            while (n2 < n) {
                ((ToxListElement)vector.get(n2)).dump(printStream);
                ++n2;
            }
        } else {
            Vector vector = this.expression.evaluate();
            if (vector.size() != 1) {
                ToXgene.error("invalid expression: " + this.expression.expression() + " results in a set with " + vector.size() + " values");
            }
            if (this.format) {
                String string = (String)vector.get(0);
                switch (this.type) {
                    case 2: {
                        printStream.print(this.decimalFormat.format(Integer.parseInt(string)));
                        break;
                    }
                    case 3: {
                        printStream.print(this.decimalFormat.format(Double.parseDouble(string)));
                        break;
                    }
                    case 4: {
                        Date date = Date.parseDate(string);
                        printStream.print(this.decimalFormat.format(date.getTime()));
                        break;
                    }
                    default: {
                        printStream.print(string);
                        break;
                    }
                }
            } else {
                printStream.print((String)vector.get(0));
            }
        }
    }

    public void generate(ToxListElement toxListElement, ToxList toxList) {
        if (this.type == 5) {
            Vector vector = ((Query)this.expression).evaluateSCAN();
            int n = vector == null ? 0 : vector.size();
            int n2 = 0;
            while (n2 < n) {
                toxListElement.addChild((ToxListElement)vector.get(n2));
                ++n2;
            }
        } else {
            super.generate(toxListElement, toxList);
        }
    }

    public String baseType() {
        switch (this.type) {
            case 2: {
                return "integer";
            }
            case 3: {
                return "real";
            }
            case 4: {
                return "date";
            }
            case 1: {
                return "string";
            }
            case 5: {
                return "complex";
            }
        }
        return null;
    }

    public boolean unique() {
        return this.unique;
    }

    public int getMaxQtty() {
        return this.expression.getQtty();
    }

    public int getMinQtty() {
        return this.min_qtty;
    }

    public void setQtty(int n) {
        this.qtty = n;
    }

    public void resetRandomGen() {
    }
}

