/*
 * Decompiled with CFR 0.152.
 */
package genes.lists;

import genes.lists.SingleClause;
import genes.lists.ToxList;
import genes.lists.ToxListElement;
import genes.trees.ToxScan;
import java.io.Serializable;
import java.util.Vector;
import org.w3c.dom.Node;

public class WhereClause
implements Serializable {
    private static final int LIST = 1;
    private static final int SCAN = 2;
    private String where;
    private String prefix;
    private ToxList list;
    private ToxScan scan;
    private int mode;
    private Vector atoms;
    private Node node;

    public WhereClause(String string, ToxList toxList, Node node) {
        this.where = string;
        this.list = toxList;
        this.prefix = null;
        this.node = node;
        this.atoms = new Vector();
        this.mode = 1;
        this.initialize();
    }

    public WhereClause(String string, ToxScan toxScan, Node node) {
        this.where = string;
        this.scan = toxScan;
        this.prefix = null;
        this.node = node;
        this.atoms = new Vector();
        this.mode = 2;
        this.initialize();
    }

    public WhereClause(String string, ToxList toxList, String string2) {
        this.where = string;
        this.list = toxList;
        this.prefix = string2;
        this.node = this.node;
        this.atoms = new Vector();
        this.mode = 1;
        this.initialize();
    }

    public WhereClause(String string, ToxScan toxScan, String string2) {
        this.where = string;
        this.scan = toxScan;
        this.prefix = string2;
        this.node = this.node;
        this.atoms = new Vector();
        this.mode = 2;
        this.initialize();
    }

    private void initialize() {
        int n = 0;
        int n2 = 0;
        do {
            String string = (n2 = this.where.indexOf(";", n)) == -1 ? this.where.substring(n) : this.where.substring(n, n2);
            n = n2 + 1;
            if (this.mode == 1) {
                this.atoms.add(new SingleClause(string, this.list, this.prefix, this.node));
                continue;
            }
            this.atoms.add(new SingleClause(string, this.scan, this.prefix, this.node));
        } while (n2 != -1);
    }

    public boolean evaluate(ToxListElement toxListElement) {
        int n = 0;
        while (n < this.atoms.size()) {
            if (!((SingleClause)this.atoms.elementAt(n)).evaluate(toxListElement)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean evaluate() {
        int n = 0;
        while (n < this.atoms.size()) {
            if (!((SingleClause)this.atoms.elementAt(n)).evaluate()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String clause() {
        return this.where;
    }
}

