/*
 * Decompiled with CFR 0.152.
 */
package genes.lists;

import genes.lists.ToxList;
import genes.lists.ToxListElement;
import genes.lists.ToxListRootElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import toxgene.ToXgene;

public class ToxListParser
extends DefaultHandler {
    private static byte EMPTY = 0;
    private static byte ELEMENTS = 1;
    private static byte CDATA = (byte)2;
    private int level = 0;
    private byte[] cdataLevel;
    private StringBuffer buffer = new StringBuffer();
    private ToxListRootElement root;
    private String geneName;
    private ToxListElement[] current;
    private ToxList list;
    private String uri;
    private static boolean noAttrs;

    public ToxListParser(String string, ToxList toxList, String string2) {
        this.cdataLevel = new byte[1];
        this.current = new ToxListElement[1];
        this.uri = string;
        this.list = toxList;
        noAttrs = true;
        this.geneName = string2;
    }

    public ToxListRootElement parse() {
        try {
            XMLReader xMLReader = (XMLReader)Class.forName("org.apache.xerces.parsers.SAXParser").newInstance();
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            xMLReader.setFeature("http://xml.org/sax/features/validation", false);
            xMLReader.parse(this.uri);
        }
        catch (SAXParseException sAXParseException) {
            sAXParseException.printStackTrace(System.err);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                sAXException.getException().printStackTrace(System.err);
            } else {
                sAXException.printStackTrace(System.err);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return this.root;
    }

    /*
     * Unable to fully structure code
     */
    public void startElement(String var1_1, String var2_2, String var3_3, Attributes var4_4) {
        block11: {
            block10: {
                if (this.level == 0) {
                    if (this.root != null) {
                        ToXgene.error("Document has multiple root elements.");
                    }
                    var6_5 = ToXgene.getTagNumber(var2_2);
                    var7_9 = ToXgene.getTagNumber(this.geneName);
                    this.root = new ToxListRootElement(var6_5, var7_9);
                    var5_12 = this.root;
                } else {
                    var6_6 = this.current[this.level - 1];
                    var7_9 = ToXgene.getTagNumber(var2_2);
                    var5_12 = var6_6.addChild(var7_9);
                }
                try {
                    this.current[this.level] = var5_12;
                    break block10;
                }
                catch (ArrayIndexOutOfBoundsException var6_7) {
                    var7_10 = this.current;
                    this.current = new ToxListElement[var7_10.length + 1];
                    var8_13 = 0;
                    ** while (var8_13 < var7_10.length)
                }
lbl-1000:
                // 1 sources

                {
                    this.current[var8_13] = var7_10[var8_13];
                    ++var8_13;
                    continue;
                }
lbl23:
                // 1 sources

                this.current[this.level] = var5_12;
            }
            if (ToxListParser.noAttrs && var4_4 != null && var4_4.getLength() != 0) {
                ToXgene.warning("ignoring attributes in document " + var1_1);
                ToxListParser.noAttrs = false;
            }
            try {
                this.cdataLevel[this.level] = ToxListParser.ELEMENTS;
                break block11;
            }
            catch (ArrayIndexOutOfBoundsException var6_8) {
                var7_11 = this.cdataLevel;
                this.cdataLevel = new byte[var7_11.length + 1];
                var8_13 = 0;
                ** while (var8_13 < var7_11.length)
            }
lbl-1000:
            // 1 sources

            {
                this.cdataLevel[var8_13] = var7_11[var8_13];
                ++var8_13;
                continue;
            }
lbl39:
            // 1 sources

            this.cdataLevel[this.level] = ToxListParser.ELEMENTS;
        }
        ++this.level;
    }

    public void endElement(String string, String string2, String string3) {
        if (this.cdataLevel[this.level] == CDATA) {
            this.current[this.level - 1].setContent(this.buffer.toString());
        }
        this.cdataLevel[this.level] = EMPTY;
        --this.level;
    }

    public void characters(char[] cArray, int n, int n2) {
        if (cArray[0] == '\n') {
            return;
        }
        if (this.level == this.cdataLevel.length) {
            byte[] byArray = this.cdataLevel;
            this.cdataLevel = new byte[byArray.length + 1];
            int n3 = 0;
            while (n3 < byArray.length) {
                this.cdataLevel[n3] = byArray[n3];
                ++n3;
            }
            this.cdataLevel[this.level] = EMPTY;
        }
        if (this.cdataLevel[this.level] == EMPTY) {
            this.cdataLevel[this.level] = CDATA;
            this.buffer.delete(0, this.buffer.length());
            this.buffer.append(cArray, n, n2);
        }
    }

    public void warning(SAXParseException sAXParseException) {
        System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) {
        System.out.println("Document " + this.uri + " cannot be parsed:");
        System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        System.exit(1);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.out.println("Document " + this.uri + " cannot be parsed:");
        System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        System.exit(1);
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }
}

