/*
 * Decompiled with CFR 0.152.
 */
package genes.lists;

import genes.lists.ToxListElementException;
import java.io.PrintStream;
import java.io.Serializable;
import toxgene.ToXgene;
import util.ToxVector;

public class ToxListElement
implements Serializable {
    protected static byte EMPTY = 1;
    protected static byte ELEMENTS = (byte)2;
    protected static byte CDATA = (byte)3;
    protected int tagNumber;
    protected ToxVector children;
    protected char[] cdata;
    protected byte contents;

    public ToxListElement(int n) {
        this.tagNumber = n;
        this.contents = EMPTY;
        this.cdata = null;
    }

    public ToxListElement addChild(int n) {
        if (this.contents == EMPTY) {
            this.children = new ToxVector();
            this.contents = ELEMENTS;
        } else if (this.contents == CDATA) {
            // empty if block
        }
        ToxListElement toxListElement = new ToxListElement(n);
        this.children.add(toxListElement);
        return toxListElement;
    }

    public void addChild(ToxListElement toxListElement) {
        if (this.contents == EMPTY) {
            this.children = new ToxVector();
            this.contents = ELEMENTS;
        } else if (this.contents == CDATA) {
            // empty if block
        }
        this.children.add(toxListElement);
    }

    public void setContent(String string) throws ToxListElementException {
        if (this.contents == EMPTY) {
            int n = string.length();
            this.cdata = new char[n];
            string.getChars(0, n, this.cdata, 0);
            this.contents = CDATA;
        } else if (this.contents == ELEMENTS) {
            throw new ToxListElementException("no mixed element content model allowed for tox-lists");
        }
    }

    public ToxVector getChildrenByTagNumber(int n) {
        ToxVector toxVector = null;
        boolean bl = true;
        int n2 = 0;
        while (n2 < this.children.size()) {
            if (((ToxListElement)this.children.get((int)n2)).tagNumber == n) {
                if (bl) {
                    toxVector = new ToxVector(1);
                    bl = false;
                }
                toxVector.add(this.children.get(n2));
            }
            ++n2;
        }
        return toxVector;
    }

    public ToxVector getChildren() {
        return this.children;
    }

    public void removeChild(int n) {
        this.children.remove(n);
    }

    public String getContent() throws ToxListElementException {
        if (this.contents == EMPTY) {
            return "";
        }
        if (this.contents == CDATA) {
            return new String(this.cdata);
        }
        throw new ToxListElementException("\nelement <" + this.getTagName() + "> has no CDATA content");
    }

    public int getTagNumber() {
        return this.tagNumber;
    }

    public String getTagName() {
        return ToXgene.getTagName(this.tagNumber);
    }

    public void dump(PrintStream printStream) {
        String string = ToXgene.getTagName(this.tagNumber);
        printStream.print("<" + string);
        printStream.print(">");
        if (this.contents == ELEMENTS) {
            int n = 0;
            while (n < this.children.size()) {
                ((ToxListElement)this.children.get(n)).dump(printStream);
                ++n;
            }
        } else if (this.contents == CDATA) {
            printStream.print(this.cdata);
        }
        printStream.print("</" + string + ">");
    }
}

