/*
 * Decompiled with CFR 0.152.
 */
package genes.lists;

import genes.lists.ListGene;
import genes.lists.PathNotFoundException;
import genes.lists.ToxListElement;
import genes.lists.ToxListElementException;
import genes.lists.ToxListParser;
import genes.lists.ToxListRootElement;
import genes.lists.WhereClause;
import genes.trees.ToxElement;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;
import org.w3c.dom.Node;
import toxgene.ToXgene;
import util.ObjectCloner;
import util.ToxVector;

public class ToxList
implements Serializable,
Runnable {
    private int threadCount = 0;
    private int workingThreads;
    private int tc2 = 0;
    private Vector geneToxScans;
    private int parallelMode;
    protected int startLoop;
    protected int endLoop;
    protected int curLoop;
    protected int numThreads;
    protected Thread[] lookupThreads;
    private String listName;
    private ToxListRootElement root;
    private ToxElement gene;
    private Vector keyPaths;
    private Vector keys;
    private WhereClause whereClause;
    private String uniquePath;
    private String where;
    private String uri;
    private boolean readFromFile;
    private boolean abort;
    private boolean dump;
    private int usedBy = 0;
    private Vector uses;
    private Node templateNode;
    private int currentLoop;
    private boolean checkUnique;
    private boolean checkWhere;

    public ToxList(String string, ToxElement toxElement, String string2, String string3, boolean bl, Node node) {
        this.listName = string;
        this.gene = toxElement;
        this.where = string3;
        this.uniquePath = string2;
        this.dump = bl;
        this.templateNode = node;
        this.readFromFile = false;
    }

    public ToxList(String string, ToxElement toxElement, String string2, String string3, boolean bl, String string4, boolean bl2, Node node) {
        this.listName = string;
        this.gene = toxElement;
        this.where = string3;
        this.uniquePath = string2;
        this.dump = bl;
        this.uri = string4;
        this.abort = bl2;
        this.templateNode = node;
        this.readFromFile = true;
    }

    public void addReference() {
        ++this.usedBy;
    }

    public void removeReference() {
        --this.usedBy;
        if (this.usedBy == 0) {
            this.root = null;
            ToXgene.deleteList(this.listName);
        }
    }

    public void references(Vector vector) {
        this.uses = vector;
        int n = 0;
        while (n < this.uses.size()) {
            ((ToxList)this.uses.get(n)).addReference();
            ++n;
        }
    }

    public void generate(int n) {
        if (this.usedBy == 0 && !this.dump) {
            ToXgene.warning("list " + this.listName + " is declared but never used.");
            return;
        }
        if (this.uniquePath.length() != 0) {
            this.keyPaths = new Vector();
            this.keys = new Vector();
            this.processUniquePath(this.uniquePath);
            this.checkUnique = true;
        }
        if (this.where.length() > 0) {
            this.checkWhere = true;
            this.whereClause = new WhereClause(this.where, this, this.templateNode);
            this.checkWhere = true;
        }
        if (this.readFromFile) {
            this.readFromFile();
        } else {
            this.buildFromScratch(n);
        }
        this.gene = null;
        this.keys = null;
        int n2 = this.uses != null ? this.uses.size() : 0;
        int n3 = 0;
        while (n3 < n2) {
            ((ToxList)this.uses.get(n3)).removeReference();
            ++n3;
        }
        if (this.dump) {
            // empty if block
        }
    }

    private void buildFromScratch(int n) {
        boolean bl = false;
        int n2 = ToXgene.getTagNumber(this.listName);
        int n3 = ToXgene.getTagNumber(this.gene.name());
        this.root = new ToxListRootElement(n2, n3);
        int n4 = 0;
        if (n > 1) {
            n4 = this.gene.numToxScans();
        }
        if (n > 1 && n4 < 2) {
            if (n4 == 1) {
                this.parallelMode = 2;
                this.gene.populate();
            } else {
                this.parallelMode = 1;
            }
            int n5 = this.gene.getQtty();
            this.root.setChildrenCapacity(n5);
            this.geneToxScans = new Vector();
            this.gene.disableToxScans(this.geneToxScans);
            this.fireThreads(n5, n);
        } else {
            int n6;
            int n7 = this.gene.getQtty();
            int n8 = n6 = n7 > 19 ? n7 / 19 : 19;
            if (n6 * 19 < n7) {
                ++n6;
            }
            int n9 = 0;
            int n10 = 0;
            System.out.print("Generating " + n7 + " elements in " + this.listName + ":     ");
            int n11 = 0;
            while (n11 < n7) {
                ToxListElement toxListElement = this.gene.instance(this);
                if (this.checkUnique && !this.checkUnique(toxListElement)) {
                    bl = true;
                }
                if (this.checkWhere && !this.whereClause.evaluate(toxListElement)) {
                    bl = true;
                }
                if (bl) {
                    this.gene.failed();
                    bl = false;
                    --n11;
                } else {
                    this.root.addChild(toxListElement);
                    if (++n9 == n6) {
                        System.out.print("\b\b\b" + (n10 += 5) + "%");
                        n9 = 0;
                    }
                }
                ++n11;
            }
        }
        System.out.println("\b\b\b\b Done!");
    }

    private void readFromFile() {
        ToxListParser toxListParser = new ToxListParser(this.uri, this, this.gene.name());
        System.out.print("Reading list " + this.listName + " from " + this.uri + ": ");
        this.root = toxListParser.parse();
        ToxVector toxVector = this.root.getChildren();
        toxListParser = null;
        if (this.checkUnique || this.checkWhere) {
            int n;
            int n2 = ((Vector)toxVector).size();
            int n3 = n = n2 > 19 ? n2 / 19 : 19;
            if (n * 19 < n2) {
                ++n;
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            System.out.print("Done! " + n2 + " elements read.\n" + "Checking list integrity: ");
            int n7 = 0;
            while (n7 < n2) {
                PrintStream printStream;
                ByteArrayOutputStream byteArrayOutputStream;
                ToxListElement toxListElement = (ToxListElement)((Vector)toxVector).get(n7);
                if (this.checkUnique && !this.checkUnique(toxListElement)) {
                    if (this.abort) {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        printStream = new PrintStream(byteArrayOutputStream);
                        toxListElement.dump(printStream);
                        ToXgene.error("list element element violates UNIQUE constraint:" + byteArrayOutputStream.toString(), this.templateNode);
                    }
                    this.root.removeChild(n7);
                    --n2;
                    ++n6;
                } else if (this.checkWhere && !this.whereClause.evaluate(toxListElement)) {
                    if (this.abort) {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        printStream = new PrintStream(byteArrayOutputStream);
                        toxListElement.dump(printStream);
                        ToXgene.error("list element element violates WHERE clause:" + byteArrayOutputStream.toString(), this.templateNode);
                    }
                    this.root.removeChild(n7);
                    --n2;
                    ++n6;
                } else if (++n4 == n) {
                    System.out.print("\b\b\b" + (n5 += 5) + "%");
                    n4 = 0;
                }
                ++n7;
            }
            System.out.println(" Done!");
            if (n6 > 0) {
                ToXgene.warning(n6 + " elements were discarded from list " + this.listName);
            }
        } else {
            System.out.println("Done! " + ((Vector)toxVector).size() + " elements read.");
        }
    }

    private void processUniquePath(String string) {
        int n;
        ToXgene.explain("Processing \"unique\" clause: " + string);
        int n2 = 0;
        do {
            String string2;
            if ((n = string.indexOf(44, n2)) != -1) {
                string2 = string.substring(n2, n);
                n2 = n + 1;
            } else {
                string2 = string.substring(n2);
            }
            if (this.getType(this.listName + "/" + string2).compareTo("complex") == 0) {
                ToXgene.error("unique path \"" + string + "\" results complex values", this.templateNode);
            }
            this.keyPaths.add(string2);
        } while (n != -1);
    }

    private boolean checkUnique(ToxListElement toxListElement) {
        int n = 0;
        while (n < this.keyPaths.size()) {
            if (!this.checkUnique(toxListElement, (String)this.keyPaths.get(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkUnique(ToxListElement toxListElement, String string) {
        Object object;
        int n = string.indexOf(47);
        String string2 = null;
        if (n == -1) {
            string2 = toxListElement.getContent();
        } else {
            String string3 = string.substring(n + 1);
            object = this.string2Num(string3);
            ToxVector toxVector = this.queryPath(toxListElement, (int[])object);
            if (toxVector == null || toxVector != null && toxVector.size() != 1) {
                ToXgene.error("unique path \"" + string3 + "\" returns a set of literals!", this.templateNode);
            }
            string2 = string2 == null ? ((ToxListElement)toxVector.get(0)).getContent() : string2.concat(((ToxListElement)toxVector.get(0)).getContent());
        }
        object = this;
        synchronized (object) {
            block7: {
                int n2 = Collections.binarySearch(this.keys, string2);
                if (n2 >= 0) break block7;
                this.keys.add(-1 - n2, string2);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public void dump() {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(this.listName + ".xml"));
            printStream.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            printStream.println("<!-- generated by ToXgene Version 1.1a on " + new Date().toString() + " -->");
        }
        catch (Exception exception) {
            System.out.println("Couldn't create " + this.listName + ".xml");
            System.exit(1);
        }
        System.out.print("Writing list " + this.listName + " to " + this.listName + ".xml... ");
        this.root.dump(printStream);
        System.out.println("Done!");
        printStream.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getType(String string) throws PathNotFoundException {
        String string2;
        int n = string.indexOf(47);
        String string3 = null;
        if (n != -1) {
            String string4 = string.substring(0, n);
            string2 = string.substring(n + 1);
            if (string4.compareTo(this.listName) != 0) throw new PathNotFoundException();
            n = string2.indexOf(47);
            if (n == -1) {
                if (string2.compareTo(this.gene.name()) != 0) throw new PathNotFoundException();
                return this.gene.getType();
            }
        } else {
            if (string.compareTo(this.listName) != 0) throw new PathNotFoundException();
            return "complex";
        }
        if (this.gene.name().compareTo(string2.substring(0, n)) != 0) throw new PathNotFoundException();
        string3 = this.queryType(this.gene, string2.substring(n + 1));
        if (string3 != null) return string3;
        throw new PathNotFoundException();
    }

    private String queryType(ListGene listGene, String string) {
        int n = string.indexOf(47);
        String string2 = null;
        Vector vector = null;
        switch (n) {
            case -1: {
                int n2;
                try {
                    vector = listGene.getChildrenByName(string);
                }
                catch (ToxListElementException toxListElementException) {
                    ToXgene.error("invalid path expression: node \"" + string + "\" is a child node", this.templateNode);
                }
                int n3 = n2 = vector == null ? 0 : vector.size();
                if (n2 <= 0) break;
                int n4 = 0;
                while (n4 < n2) {
                    String string3 = ((ListGene)vector.get(n4)).getType();
                    string2 = this.reconcile(string2, string3);
                    ++n4;
                }
                break;
            }
            case 0: {
                int n5;
                try {
                    vector = listGene.getChildren();
                }
                catch (ToxListElementException toxListElementException) {
                    ToXgene.error("invalid path expression: node \"" + listGene.name() + "\" is a child node", this.templateNode);
                }
                int n6 = n5 = vector == null ? 0 : vector.size();
                if (n5 <= 0) break;
                int n7 = 0;
                while (n7 < n5) {
                    String string4 = this.queryType((ListGene)vector.get(n7), string.substring(1));
                    string2 = this.reconcile(string2, string4);
                    ++n7;
                }
                break;
            }
            default: {
                int n8;
                String string5 = string.substring(0, n);
                try {
                    vector = listGene.getChildrenByName(string5);
                }
                catch (ToxListElementException toxListElementException) {
                    ToXgene.error("invalid path expression: node \"" + string5 + "\" is a child node", this.templateNode);
                }
                int n9 = n8 = vector == null ? 0 : vector.size();
                if (n8 <= 0) break;
                int n10 = 0;
                while (n10 < n8) {
                    String string6 = this.queryType((ListGene)vector.get(n10), string.substring(n + 1));
                    string2 = this.reconcile(string2, string6);
                    ++n10;
                }
                break block3;
            }
        }
        return string2;
    }

    private String reconcile(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        if (string.compareTo(string2) == 0) {
            return string;
        }
        if (string.compareTo("string") == 0 || string2.compareTo("string") == 0) {
            return "string";
        }
        if (string.compareTo("complex") == 0 || string2.compareTo("complex") == 0) {
            return "complex";
        }
        if (string.compareTo("integer") == 0 && string2.compareTo("real") == 0 || string2.compareTo("integer") == 0 && string.compareTo("real") == 0) {
            return "real";
        }
        if (string.compareTo("integer") == 0 && string2.compareTo("date") == 0 || string2.compareTo("integer") == 0 && string.compareTo("date") == 0) {
            return "date";
        }
        return "complex";
    }

    public String name() {
        return this.listName;
    }

    public ToxVector query(String string) {
        int[] nArray = this.string2Num(string);
        return this.queryPath(this.root, nArray);
    }

    public ToxVector query(ToxListElement toxListElement, String string) {
        int n = string.indexOf(47);
        switch (n) {
            case -1: {
                if (string.compareTo(toxListElement.getTagName()) != 0) break;
                ToxVector toxVector = new ToxVector();
                toxVector.add(toxListElement);
                return toxVector;
            }
            case 0: {
                int[] nArray = this.string2Num(string.substring(1));
                return this.queryPath(toxListElement, nArray);
            }
            default: {
                String string2 = string.substring(0, n);
                if (string2.compareTo(toxListElement.getTagName()) != 0) break;
                int[] nArray = this.string2Num(string.substring(n + 1));
                return this.queryPath(toxListElement, nArray);
            }
        }
        return null;
    }

    private ToxVector queryPath(ToxListElement toxListElement, int[] nArray) {
        ToxVector toxVector = null;
        ToxVector toxVector2 = new ToxVector(1);
        toxVector2.add(toxListElement);
        int n = 0;
        while (n < nArray.length - 1) {
            ToxVector toxVector3 = null;
            int n2 = 0;
            while (n2 < toxVector2.size()) {
                ToxVector toxVector4 = ((ToxListElement)toxVector2.get(n2)).getChildrenByTagNumber(nArray[n]);
                if (toxVector4 != null) {
                    if (toxVector3 == null) {
                        int n3 = toxVector4.size();
                        toxVector3 = new ToxVector(n3);
                    }
                    toxVector3.addAll(toxVector4);
                }
                ++n2;
            }
            toxVector2 = toxVector3;
            ++n;
        }
        if (toxVector2 == null) {
            return null;
        }
        if (nArray[nArray.length - 1] == -1) {
            int n4 = 0;
            while (n4 < toxVector2.size()) {
                ToxVector toxVector5 = ((ToxListElement)toxVector2.get(n4)).getChildren();
                if (toxVector5 != null) {
                    if (toxVector == null) {
                        int n5 = toxVector5.size();
                        toxVector = new ToxVector(n5);
                    }
                    toxVector.addAll(toxVector5);
                }
                ++n4;
            }
        } else {
            int n6 = 0;
            while (n6 < toxVector2.size()) {
                ToxVector toxVector6 = ((ToxListElement)toxVector2.get(n6)).getChildrenByTagNumber(nArray[nArray.length - 1]);
                if (toxVector6 != null) {
                    if (toxVector == null) {
                        int n7 = toxVector6.size();
                        toxVector = new ToxVector(n7);
                    }
                    toxVector.addAll(toxVector6);
                }
                ++n6;
            }
        }
        return toxVector;
    }

    public int[] string2Num(String string) {
        int[] nArray = new int[string.length()];
        int n = 0;
        String string2 = "";
        int n2 = string.indexOf(47);
        while (n2 != -1) {
            if (n2 == 0) {
                string = string.substring(1);
            } else {
                string2 = string.substring(0, n2);
                nArray[n] = ToXgene.getTagNumber(string2);
                ++n;
                string = string.substring(n2 + 1);
            }
            n2 = string.indexOf(47);
        }
        string2 = string.substring(0);
        if (!string2.equals("")) {
            nArray[n] = ToXgene.getTagNumber(string2);
            ++n;
        } else {
            nArray[n] = ToXgene.getTagNumber("/");
            ++n;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public synchronized LoopRange loopGetRange() {
        if (this.curLoop >= this.endLoop) {
            --this.workingThreads;
            return null;
        }
        int n = this.curLoop;
        this.curLoop += (this.endLoop - this.startLoop) / this.numThreads + 1;
        int n2 = this.curLoop < this.endLoop ? this.curLoop : this.endLoop;
        LoopRange loopRange = new LoopRange(n, n2, this.tc2++);
        return loopRange;
    }

    public void fireThreads(int n, int n2) {
        this.curLoop = 0;
        this.startLoop = 0;
        this.endLoop = n;
        this.numThreads = n2;
        this.workingThreads = n2;
        this.lookupThreads = new Thread[this.numThreads];
        int n3 = 0;
        while (n3 < this.numThreads) {
            this.lookupThreads[n3] = new Thread(this);
            this.lookupThreads[n3].start();
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.numThreads) {
            try {
                this.lookupThreads[n4].join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.numThreads) {
            this.lookupThreads[n5] = null;
            ++n5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        block36: {
            var1_1 = this.loopGetRange();
            if (var1_1 == null) break block36;
            var2_2 = var1_1.start;
            var3_3 = var1_1.end;
            var4_4 = null;
            switch (this.parallelMode) {
                case 1: {
                    if (var1_1.number == 0) {
                        var4_4 = this.gene;
                    } else {
                        try {
                            var5_5 = System.currentTimeMillis();
                            var4_4 = (ToxElement)ObjectCloner.deepCopy(this.gene);
                            var7_11 = System.currentTimeMillis();
                            System.out.println("cloning time: " + (var7_11 - var5_5) + "ms.");
                        }
                        catch (Exception var5_6) {
                            System.out.flush();
                            System.exit(1);
                        }
                    }
                    var4_4.enableToxScans(this.geneToxScans, 0);
                    break;
                }
                case 2: {
                    if (var2_2 == 0) {
                        var5_7 = this.gene.getToxList();
                        var4_4 = this.gene;
                        var4_4.setToxList(var5_7);
                    } else {
                        try {
                            var4_4 = (ToxElement)ObjectCloner.deepCopy(this.gene);
                        }
                        catch (Exception var5_8) {
                            // empty catch block
                        }
                    }
                    var4_4.enableToxScans(this.geneToxScans, 0);
                    var4_4.setLoopInterval(var2_2, var3_3);
                }
            }
            while (this.threadCount != var1_1.number) {
                try {
                    this.wait();
                }
                catch (Exception var5_9) {
                    // empty catch block
                }
            }
            var5_10 = this;
            synchronized (var5_10) {
                if (var1_1.number != 0) {
                    var4_4.resetRandomGen();
                }
                ++this.threadCount;
                // MONITOREXIT @DISABLED, blocks:[3, 5] lbl51 : MonitorExitStatement: MONITOREXIT : var5_10
                if (true) ** GOTO lbl60
            }
            do {
                try {
                    this.wait();
                }
                catch (Exception var9_13) {
                    // empty catch block
                }
lbl60:
                // 3 sources

            } while (this.threadCount < this.workingThreads);
            var9_14 = false;
            if (var1_1.number == 0) {
                var10_15 = var1_1.end - var1_1.start;
                v0 = var11_17 = var10_15 > 19 ? var10_15 / 19 : 19;
                if (var11_17 * 19 < var10_15) {
                    ++var11_17;
                }
                var12_19 = 0;
                var13_20 = 0;
                System.out.print("Generating list " + this.listName + ":     ");
                var14_21 = var2_2;
                while (var14_21 < var3_3) {
                    var15_22 = var4_4.instance(this);
                    if (this.checkUnique && !this.checkUnique(var15_22)) {
                        var9_14 = true;
                    }
                    if (this.checkWhere && !this.whereClause.evaluate(var15_22)) {
                        var9_14 = true;
                    }
                    if (var9_14) {
                        var4_4.failed();
                        var9_14 = false;
                        --var14_21;
                    } else {
                        this.root.addChild(var14_21, var15_22);
                        if (++var12_19 == var11_17) {
                            System.out.print("\b\b\b" + (var13_20 += 5) + "%");
                            var12_19 = 0;
                        }
                    }
                    ++var14_21;
                }
            } else {
                var10_16 = var2_2;
                while (var10_16 < var3_3) {
                    var11_18 = var4_4.instance(this);
                    if (this.checkUnique && !this.checkUnique(var11_18)) {
                        var9_14 = true;
                    }
                    if (this.checkWhere && !this.whereClause.evaluate(var11_18)) {
                        var9_14 = true;
                    }
                    if (var9_14) {
                        var4_4.failed();
                        var9_14 = false;
                        --var10_16;
                    } else {
                        this.root.addChild(var10_16, var11_18);
                    }
                    ++var10_16;
                }
            }
            var4_4 = null;
        }
    }

    protected class LoopRange {
        public int start;
        public int end;
        public int number;

        public LoopRange(int n, int n2, int n3) {
            this.start = n;
            this.end = n2;
            this.number = n3;
        }
    }
}

