/*
 * Decompiled with CFR 0.152.
 */
package genes.lists;

import genes.lists.ToxList;
import genes.lists.ToxListElement;
import genes.trees.BinaryExpression;
import genes.trees.Constant;
import genes.trees.Expression;
import genes.trees.ExpressionParser;
import genes.trees.Query;
import genes.trees.ToxScan;
import java.io.Serializable;
import java.util.Vector;
import org.w3c.dom.Node;
import toxgene.ToXgene;
import util.Date;

public class SingleClause
implements Serializable {
    private static final int EQ = 1;
    private static final int DIF = 2;
    private static final int LT = 3;
    private static final int GT = 4;
    private static final int LEQ = 5;
    private static final int GEQ = 6;
    private static final int EXISTS = 7;
    private static final int ONE = 0;
    private static final int ALL = 1;
    private static final int ANY = 2;
    private static final int LIST = 1;
    private static final int SCAN = 2;
    private int operation;
    private Expression LHSE;
    private Expression RHSE;
    private int DT;
    private int modeLHS;
    private int modeRHS;
    private int mode;
    private ToxList list;
    private ToxScan scan;
    private Vector valuesLHS;
    private Vector valuesRHS;
    private String prefix;
    private Node node;

    public SingleClause(String string, ToxList toxList, String string2, Node node) {
        this.mode = 1;
        this.list = toxList;
        this.prefix = string2;
        this.node = node;
        this.initialize(string);
    }

    public SingleClause(String string, ToxScan toxScan, String string2, Node node) {
        this.mode = 2;
        this.scan = toxScan;
        this.prefix = string2;
        this.node = node;
        this.initialize(string);
    }

    private void initialize(String string) {
        int n = 0;
        int n2 = string.indexOf(40);
        if (n2 == -1) {
            ToXgene.error("could not parse a where clause from " + string, this.node);
        }
        String string2 = string.substring(n, n2);
        n = n2 + 1;
        if (string2.compareTo("EQ") == 0) {
            this.operation = 1;
        } else if (string2.compareTo("DIF") == 0) {
            this.operation = 2;
        } else if (string2.compareTo("LT") == 0) {
            this.operation = 3;
        } else if (string2.compareTo("LEQ") == 0) {
            this.operation = 5;
        } else if (string2.compareTo("GT") == 0) {
            this.operation = 4;
        } else if (string2.compareTo("GEQ") == 0) {
            this.operation = 6;
        } else if (string2.compareTo("EXISTS") == 0) {
            this.operation = 7;
        } else {
            ToXgene.error("invalid operator: " + string2, this.node);
        }
        if (this.operation != 7) {
            n2 = string.indexOf(44, n);
            if (n2 == -1) {
                ToXgene.error("could not parse a where clause from " + string, this.node);
            }
            string2 = string.substring(n, n2);
            this.modeLHS = this.getMode(string2);
            if (this.modeLHS == -1) {
                ToXgene.error("could not parse a where clause from " + string, this.node);
            }
            String string3 = this.getExpression(string2);
            this.LHSE = this.mode == 1 ? ExpressionParser.parse(string3, this.list, this.prefix, this.node) : ExpressionParser.parse(string3, this.scan, this.prefix, this.node);
            int n3 = this.LHSE.expressionType();
            n = n2 + 1;
            if ((n2 = string.indexOf(41, n)) == -1 || n2 + 1 < string.length()) {
                ToXgene.error("could not parse a where clause from " + string, this.node);
            }
            string2 = string.substring(n, n2);
            this.modeRHS = this.getMode(string2);
            if (this.modeRHS == -1) {
                ToXgene.error("could not parse a where clause from " + string, this.node);
            }
            String string4 = this.getExpression(string2);
            this.RHSE = this.mode == 1 ? ExpressionParser.parse(string4, this.list, this.prefix, this.node) : ExpressionParser.parse(string4, this.scan, this.prefix, this.node);
            int n4 = this.RHSE.expressionType();
            this.DT = 1;
            if (n3 != 1) {
                if (n3 == n4) {
                    this.DT = n3;
                } else if (n3 == 2 && n4 == 3 || n3 == 2 && n4 == 3) {
                    this.DT = 3;
                    if (n3 == 2) {
                        ToXgene.warning("casting INTEGER values in \"" + this.LHSE.expression() + "\" to REAL.");
                    }
                    if (n4 == 2) {
                        ToXgene.warning("casting INTEGER values in \"" + this.RHSE.expression() + "\" to REAL.");
                    }
                }
            } else {
                if (n4 == 2) {
                    ToXgene.warning("casting INTEGER value in \"" + string4 + "\" to STRING.");
                }
                if (n4 == 3) {
                    ToXgene.warning("casting REAL value in \"" + string4 + "\" to STRING.");
                }
                if (n4 == 4) {
                    ToXgene.warning("casting DATE value in \"" + string4 + "\" to STRING.");
                }
            }
        } else {
            n2 = string.indexOf(41, n);
            if (n2 == -1 || n2 + 1 < string.length()) {
                ToXgene.error("could not parse a where clause from " + string, this.node);
            }
            string2 = string.substring(n, n2);
            this.modeRHS = this.getMode(string2);
            if (this.modeRHS == -1) {
                ToXgene.error("could not parse a where clause from " + string, this.node);
            }
            if (this.modeRHS != 0) {
                ToXgene.explain("the EXISTS operator is insensitive to ANY/ALL modifiers. In where clause " + string);
            }
            String string5 = this.getExpression(string2);
            this.RHSE = this.mode == 1 ? ExpressionParser.parse(string5, this.list, this.prefix, this.node) : ExpressionParser.parse(string5, this.scan, this.prefix, this.node);
            if (this.RHSE instanceof Constant) {
                ToXgene.warning("Ignoring EXISTS operator defined in terms of a constant in where clause " + string);
            }
        }
    }

    private String getExpression(String string) {
        int n = string.indexOf(123);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1, string.length() - 1);
    }

    private int getMode(String string) {
        int n = string.indexOf(123);
        if (n == -1) {
            return 0;
        }
        String string2 = string.substring(0, n);
        if (string2.compareTo("ALL") == 0) {
            return 1;
        }
        if (string2.compareTo("ANY") == 0) {
            return 2;
        }
        return -1;
    }

    public boolean evaluate() {
        if (this.mode != 2) {
            ToXgene.error("SingleClause mode was not SCAN!", this.node);
        }
        if (this.operation == 7) {
            if (this.RHSE instanceof Constant) {
                return true;
            }
            if (this.RHSE instanceof BinaryExpression) {
                this.valuesRHS = this.RHSE.evaluate();
                return this.valuesRHS.size() != 0;
            }
            if (this.RHSE instanceof Query) {
                this.valuesRHS = ((Query)this.RHSE).evaluateSCAN();
                return this.valuesRHS != null;
            }
        }
        this.valuesLHS = this.LHSE.evaluate();
        this.valuesRHS = this.RHSE.evaluate();
        switch (this.modeLHS) {
            case 0: {
                if (this.valuesLHS.size() != 1) {
                    ToXgene.error("invalid where clause: path " + this.LHSE.expression() + " results in a set of values!", this.node);
                }
                return this.iterateRHS((String)this.valuesLHS.get(0));
            }
            case 2: {
                int n = 0;
                while (n < this.valuesLHS.size()) {
                    if (this.iterateRHS((String)this.valuesLHS.get(n))) {
                        return true;
                    }
                    ++n;
                }
                return false;
            }
            case 1: {
                int n = 0;
                while (n < this.valuesLHS.size()) {
                    if (!this.iterateRHS((String)this.valuesLHS.get(n))) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
        }
        return false;
    }

    public boolean evaluate(ToxListElement toxListElement) {
        if (this.mode != 1) {
            ToXgene.error("SingleClause mode was not list!", this.node);
        }
        if (this.operation == 7) {
            if (this.RHSE instanceof Constant) {
                return true;
            }
            if (this.RHSE instanceof BinaryExpression) {
                this.valuesRHS = this.RHSE.evaluate(toxListElement);
                return this.valuesRHS.size() != 0;
            }
            if (this.RHSE instanceof Query) {
                this.valuesRHS = ((Query)this.RHSE).evaluateSCAN(toxListElement);
                return this.valuesRHS != null;
            }
        }
        this.valuesLHS = this.LHSE.evaluate(toxListElement);
        this.valuesRHS = this.RHSE.evaluate(toxListElement);
        if (this.valuesLHS.size() == 0) {
            ToXgene.error("invalid where clause: path " + this.LHSE.expression() + " results no elements!", this.node);
        }
        if (this.valuesRHS.size() == 0) {
            ToXgene.error("invalid where clause: path " + this.RHSE.expression() + " results no elements!", this.node);
        }
        switch (this.modeLHS) {
            case 0: {
                if (this.valuesLHS.size() != 1) {
                    ToXgene.error("invalid where clause: path " + this.LHSE.expression() + " results in a set of values!", this.node);
                }
                return this.iterateRHS((String)this.valuesLHS.get(0));
            }
            case 2: {
                int n = 0;
                while (n < this.valuesLHS.size()) {
                    if (this.iterateRHS((String)this.valuesLHS.get(n))) {
                        return true;
                    }
                    ++n;
                }
                return false;
            }
            case 1: {
                int n = 0;
                while (n < this.valuesLHS.size()) {
                    if (!this.iterateRHS((String)this.valuesLHS.get(n))) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
        }
        return false;
    }

    private boolean iterateRHS(String string) {
        switch (this.modeRHS) {
            case 0: {
                if (this.valuesRHS.size() != 1) {
                    ToXgene.error("invalid where clause: path " + this.RHSE.expression() + " results in a set of values!", this.node);
                }
                return this.compare(string, (String)this.valuesRHS.get(0));
            }
            case 2: {
                int n = 0;
                while (n < this.valuesRHS.size()) {
                    if (this.compare(string, (String)this.valuesRHS.get(n))) {
                        return true;
                    }
                    ++n;
                }
                return false;
            }
            case 1: {
                int n = 0;
                while (n < this.valuesRHS.size()) {
                    if (!this.compare(string, (String)this.valuesRHS.get(n))) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
        }
        return false;
    }

    private boolean compare(String string, String string2) {
        Object object = string;
        Object object2 = string2;
        switch (this.DT) {
            case 1: {
                break;
            }
            case 2: {
                object = Long.valueOf(string);
                object2 = Long.valueOf(string2);
                break;
            }
            case 3: {
                object = Double.valueOf(string);
                object2 = Double.valueOf(string2);
                break;
            }
            case 4: {
                object = Date.valueOf(string);
                object2 = Date.valueOf(string2);
            }
        }
        switch (this.operation) {
            case 1: {
                return ((Comparable)object).compareTo(object2) == 0;
            }
            case 2: {
                return ((Comparable)object).compareTo(object2) != 0;
            }
            case 3: {
                return ((Comparable)object).compareTo(object2) < 0;
            }
            case 5: {
                return ((Comparable)object).compareTo(object2) <= 0;
            }
            case 4: {
                return ((Comparable)object).compareTo(object2) > 0;
            }
            case 6: {
                return ((Comparable)object).compareTo(object2) >= 0;
            }
        }
        return false;
    }
}

