/*
 * Decompiled with CFR 0.152.
 */
package factories;

import factories.CreateGeneException;
import factories.SimpleTypeFactory;
import genes.Gene;
import genes.literals.ToxString;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import random.ToxRandom;
import random.ToxUniform;
import toxgene.ToXgene;
import util.KeyNotFoundException;

public class StringFactory
extends SimpleTypeFactory {
    private int minLength;
    private int maxLength;

    public StringFactory() {
        this.baseType = "string";
        this.reset();
    }

    private void reset() {
        this.minLength = 1;
        this.maxLength = Integer.MAX_VALUE;
    }

    public Gene createGene(NodeList nodeList) throws CreateGeneException {
        this.defined = false;
        this.reset();
        int n = 0;
        while (n < nodeList.getLength()) {
            String string;
            Node node = nodeList.item(n);
            String string2 = node.getNodeName();
            if (string2.compareTo("pattern") == 0) {
                this.processPattern(node);
            }
            if (string2.compareTo("minLength") == 0) {
                string = "";
                try {
                    string = ((Element)node).getAttributeNode("value").getNodeValue();
                    this.minLength = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new CreateGeneException("cannot parse minLength from " + string);
                }
            }
            if (string2.compareTo("maxLength") == 0) {
                string = "";
                try {
                    string = ((Element)node).getAttributeNode("value").getNodeValue();
                    this.maxLength = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new CreateGeneException("cannot parse maxLength from " + string);
                }
            }
            if (string2.compareTo("tox-string") == 0) {
                if (this.defined) {
                    throw new CreateGeneException("invalid STRING simpleType definition");
                }
                this.defined = true;
                this.gene = this.processPrimitiveType(node);
            }
            if (string2.compareTo("tox-value") == 0) {
                if (this.defined) {
                    throw new CreateGeneException("invalid STRING simpleType definition");
                }
                this.defined = true;
                this.gene = this.processToxValue(node);
            }
            ++n;
        }
        if (!this.defined) {
            throw new CreateGeneException("invalid STRING simpleType definition");
        }
        return this.gene;
    }

    public Gene createGene(Node node) {
        String string = node.getNodeName();
        this.reset();
        if (string.compareTo("tox-string") == 0) {
            return this.processPrimitiveType(node);
        }
        return this.processToxValue(node);
    }

    public Gene createGene() {
        this.minLength = 1;
        this.maxLength = 200;
        return new ToxString(new ToxUniform(this.minLength, this.maxLength));
    }

    private Gene processPrimitiveType(Node node) {
        String string = "";
        ToxRandom toxRandom = null;
        String string2 = ((Element)node).getAttributeNode("type").getNodeValue();
        try {
            string = ((Element)node).getAttributeNode("tox-distribution").getNodeValue();
            toxRandom = (ToxRandom)ToXgene.randomGenerators.get(string);
            int n = (int)toxRandom.minValue();
            int n2 = (int)toxRandom.maxValue();
            if (n < this.minLength || n2 > this.maxLength) {
                ToXgene.error("min and max values for distribution: " + string, node);
            }
        }
        catch (KeyNotFoundException keyNotFoundException) {
            ToXgene.error("distribution " + string + " definition not found!", node);
        }
        catch (NullPointerException nullPointerException) {
            String string3 = null;
            int n = 1;
            int n3 = 1;
            try {
                string3 = ((Element)node).getAttributeNode("minLength").getNodeValue();
                n = Integer.parseInt(string3);
            }
            catch (NullPointerException nullPointerException2) {
                n = this.minLength;
            }
            catch (NumberFormatException numberFormatException) {
                ToXgene.error("tox-string declaration: cannot parse an integer from " + string3, node);
            }
            try {
                string3 = ((Element)node).getAttributeNode("maxLength").getNodeValue();
                n3 = Integer.parseInt(string3);
            }
            catch (NullPointerException nullPointerException3) {
                n3 = this.maxLength == Integer.MAX_VALUE ? 200 : this.maxLength;
            }
            catch (NumberFormatException numberFormatException) {
                ToXgene.error("tox-string declaration: cannot parse an integer from " + string3, node);
            }
            if (n > n3 || n3 < 1 || n < 1) {
                ToXgene.error("invalid minLength/maxLength values: " + n + "/" + n3, node);
            }
            if (n < this.minLength || n3 > this.maxLength) {
                ToXgene.error("minLength and maxLength values out of interval [" + this.minLength + "," + this.maxLength + "]", node);
            }
            toxRandom = new ToxUniform(n, n3);
        }
        return new ToxString(string2, toxRandom);
    }
}

