/*
 * Decompiled with CFR 0.152.
 */
package factories;

import factories.CreateGeneException;
import genes.Gene;
import genes.literals.ToxString;
import genes.literals.ToxValue;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import toxgene.ToXgene;

public abstract class SimpleTypeFactory {
    protected String baseType;
    protected boolean defined = false;
    protected Gene gene = null;

    public abstract Gene createGene(NodeList var1) throws CreateGeneException;

    public abstract Gene createGene(Node var1);

    public abstract Gene createGene();

    protected void processPattern(Node node) {
        if (this.defined) {
            ToXgene.error("invalid STRING simpleType definition!", node);
        }
        this.defined = true;
        String string = ((Element)node).getAttributeNode("value").getNodeValue();
        this.gene = new ToxString(string);
    }

    protected Gene processToxValue(Node node) {
        try {
            String string = node.getFirstChild().getNodeValue();
            return new ToxValue(string, this.baseType);
        }
        catch (NullPointerException nullPointerException) {
            ToXgene.error("invalid NULL LITERAL value!", node);
            return null;
        }
    }
}

