/*
 * Decompiled with CFR 0.152.
 */
package factories;

import factories.CreateGeneException;
import factories.SimpleTypeFactory;
import genes.Gene;
import genes.literals.ToxNumber;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import random.ToxConstant;
import random.ToxRandom;
import random.ToxUniform;
import toxgene.ToXgene;
import util.KeyNotFoundException;

public class RealFactory
extends SimpleTypeFactory {
    private int type;
    private float minInclusive;
    private float maxInclusive;
    private float actualMin;
    private float actualMax;
    private String typeName;
    private String format;
    private final float SMALLEST = -3.4028235E38f;
    private final float LARGEST = Float.MAX_VALUE;
    private final float DELTA = Float.MIN_VALUE;

    public RealFactory(int n) {
        this.baseType = "real";
        this.type = n;
    }

    private void reset() {
        this.format = "";
        switch (this.type) {
            case 1018: {
                this.minInclusive = -3.4028235E38f;
                this.maxInclusive = Float.MAX_VALUE;
                this.typeName = "Decimal";
                this.format = "0.00;-0.00";
                break;
            }
            case 1019: {
                this.minInclusive = -3.4028235E38f;
                this.maxInclusive = Float.MAX_VALUE;
                this.typeName = "Float";
                break;
            }
            case 1020: {
                this.minInclusive = -3.4028235E38f;
                this.maxInclusive = Float.MAX_VALUE;
                this.typeName = "Double";
            }
        }
        this.actualMin = this.minInclusive;
        this.actualMax = this.maxInclusive;
    }

    public Gene createGene(NodeList nodeList) throws CreateGeneException {
        this.reset();
        boolean bl = false;
        boolean bl2 = false;
        this.defined = false;
        int n = 0;
        while (n < nodeList.getLength()) {
            float f;
            Node node = nodeList.item(n);
            String string = node.getNodeName();
            if (string.compareTo("minInclusive") == 0) {
                try {
                    f = Float.parseFloat(((Element)node).getAttributeNode("value").getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new CreateGeneException("invalid minInclusive value");
                }
                if (this.minInclusive > f || this.maxInclusive < f) {
                    throw new CreateGeneException("invalid minInclusive value: " + f);
                }
                this.actualMin = f;
                bl = true;
            }
            if (string.compareTo("maxInclusive") == 0) {
                try {
                    f = Float.parseFloat(((Element)node).getAttributeNode("value").getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new CreateGeneException("invalid maxInclusive value");
                }
                if (this.maxInclusive < f || this.minInclusive > f) {
                    throw new CreateGeneException("invalid maxInclusive value: " + f);
                }
                this.actualMax = f;
                bl2 = true;
            }
            if (string.compareTo("minExclusive") == 0) {
                try {
                    f = Float.parseFloat(((Element)node).getAttributeNode("value").getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new CreateGeneException("invalid minInclusive value");
                }
                if (this.minInclusive > f + Float.MIN_VALUE || this.maxInclusive < f - Float.MIN_VALUE) {
                    throw new CreateGeneException("invalid minInclusive value: " + f);
                }
                this.actualMin = f + Float.MIN_VALUE;
                bl = true;
            }
            if (string.compareTo("maxExclusive") == 0) {
                try {
                    f = Float.parseFloat(((Element)node).getAttributeNode("value").getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new CreateGeneException("invalid maxInclusive value");
                }
                if (this.maxInclusive < f - Float.MIN_VALUE || this.minInclusive > f + Float.MIN_VALUE) {
                    throw new CreateGeneException("invalid maxInclusive value: " + f);
                }
                this.actualMax = f - Float.MIN_VALUE;
                bl2 = true;
            }
            if (string.compareTo("tox-format") == 0) {
                this.format = ((Element)node).getAttributeNode("value").getNodeValue();
            }
            if (string.compareTo("pattern") == 0) {
                this.processPattern(node);
            }
            if (string.compareTo("tox-number") == 0) {
                if (this.defined) {
                    System.out.println("***** ERROR: Invalid " + this.typeName + " simpleType" + " definition!");
                    System.exit(1);
                }
                this.defined = true;
                this.gene = this.processPrimitiveType(node);
            }
            if (string.compareTo("tox-value") == 0) {
                if (this.defined) {
                    System.out.println("***** ERROR: Invalid " + this.typeName + " simpleType" + " definition!");
                    System.exit(1);
                }
                this.defined = true;
                this.gene = this.processToxValue(node);
            }
            ++n;
        }
        if (!this.defined) {
            if (bl) {
                if (bl2) {
                    this.gene = new ToxNumber(2, this.actualMin, this.actualMax, false, this.format, new ToxUniform(this.actualMin, this.actualMax));
                } else {
                    this.actualMax = this.maxInclusive + this.actualMin;
                    this.gene = new ToxNumber(2, this.actualMin, this.actualMax, false, this.format, new ToxUniform(this.actualMin, this.actualMax));
                }
            } else if (bl2) {
                if (this.actualMin < this.minInclusive) {
                    this.actualMin = this.minInclusive;
                }
                this.actualMin = this.actualMax - this.maxInclusive;
                this.gene = new ToxNumber(2, this.actualMin, this.actualMax, false, this.format, new ToxUniform(this.actualMin, this.actualMax));
            } else {
                this.actualMin = this.minInclusive / 2.0f;
                this.actualMax = this.maxInclusive / 2.0f;
                this.gene = new ToxNumber(2, this.actualMin, this.actualMax, false, this.format, new ToxUniform(this.actualMin, this.actualMax));
            }
        }
        return this.gene;
    }

    public Gene createGene(Node node) {
        String string = node.getNodeName();
        this.reset();
        if (string.compareTo("tox-number") == 0) {
            return this.processPrimitiveType(node);
        }
        return this.processToxValue(node);
    }

    public Gene createGene() {
        this.reset();
        float f = this.minInclusive / 2.0f;
        float f2 = this.maxInclusive / 2.0f;
        return new ToxNumber(2, f, f2, false, this.format, new ToxUniform(f, f2));
    }

    private Gene processPrimitiveType(Node node) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        String string = "";
        String string2 = "";
        String string3 = "";
        ToxRandom toxRandom = null;
        String string4 = ((Element)node).getAttributeNode("sequential").getNodeValue();
        boolean bl = string4.compareTo("yes") == 0;
        try {
            this.format = ((Element)node).getAttributeNode("format").getNodeValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            string = ((Element)node).getAttributeNode("tox-distribution").getNodeValue();
            toxRandom = (ToxRandom)ToXgene.randomGenerators.get(string);
            if (bl) {
                f = this.getMinValue(node);
                f2 = this.getMaxValue(node);
                if (toxRandom.getClass().getName().compareTo("random.ToxConstant") != 0) {
                    System.out.println("***** ERROR: Invalid sequential tox-number definition: the random generator is not a ToxConstant.");
                    System.exit(1);
                }
            } else {
                f = (long)toxRandom.minValue();
                f2 = (long)toxRandom.maxValue();
            }
        }
        catch (KeyNotFoundException keyNotFoundException) {
            System.out.println("***** ERROR: " + string + " distribution not " + "defined!");
            System.exit(1);
        }
        catch (NullPointerException nullPointerException) {
            f = this.getMinValue(node);
            f2 = this.getMaxValue(node);
            toxRandom = bl ? new ToxConstant(1.0f) : new ToxUniform(f, f2);
        }
        if (f > -3.4028235E38f) {
            if (f2 - f == Float.POSITIVE_INFINITY) {
                f2 = Float.MAX_VALUE - f;
            }
        } else if (f2 == Float.MAX_VALUE) {
            f = -1.7014117E38f;
            f2 = 1.7014117E38f;
        } else if (f2 - f == Float.POSITIVE_INFINITY) {
            f = f2 - Float.MAX_VALUE;
        }
        return new ToxNumber(2, f, f2, bl, this.format, toxRandom);
    }

    private float getMinValue(Node node) {
        String string = "";
        float f = 0.0f;
        try {
            string = ((Element)node).getAttributeNode("minInclusive").getNodeValue();
            f = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            ToXgene.error("invalid minValue: cannot parse a number from " + string, node);
        }
        catch (NullPointerException nullPointerException) {
            f = this.actualMin;
        }
        return f;
    }

    private float getMaxValue(Node node) {
        String string = "";
        float f = 0.0f;
        try {
            string = ((Element)node).getAttributeNode("maxInclusive").getNodeValue();
            f = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            ToXgene.error("invalid minValue: cannot parse a number from " + string, node);
        }
        catch (NullPointerException nullPointerException) {
            f = this.actualMax;
        }
        return f;
    }
}

