/*
 * Decompiled with CFR 0.152.
 */
package factories;

import factories.CreateGeneException;
import factories.SimpleTypeFactory;
import genes.Gene;
import genes.literals.ToxNumber;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import random.ToxConstant;
import random.ToxRandom;
import random.ToxUniform;
import toxgene.ToXgene;
import util.KeyNotFoundException;

public class IntegerFactory
extends SimpleTypeFactory {
    private int type;
    private long minInclusive;
    private long maxInclusive;
    private long actualMin;
    private long actualMax;
    private String typeName;
    private String format;
    private final long SMALLEST = -9223372036854775807L;
    private final long DELTA = Long.MIN_VALUE;
    private final long LARGEST = Long.MAX_VALUE;

    public IntegerFactory(int n) {
        this.baseType = "integer";
        this.type = n;
    }

    private void reset() {
        this.format = "";
        switch (this.type) {
            case 1007: {
                this.minInclusive = -9223372036854775807L;
                this.maxInclusive = Long.MAX_VALUE;
                this.typeName = "Integer";
                break;
            }
            case 1014: {
                this.minInclusive = -9223372036854775807L;
                this.maxInclusive = Long.MAX_VALUE;
                this.typeName = "Long";
                break;
            }
            case 1015: {
                this.minInclusive = 0L;
                this.maxInclusive = Long.MAX_VALUE;
                this.typeName = "Unisgned Long";
                break;
            }
            case 1012: {
                this.minInclusive = Integer.MIN_VALUE;
                this.maxInclusive = Integer.MAX_VALUE;
                this.typeName = "Int";
                break;
            }
            case 1013: {
                this.minInclusive = 0L;
                this.maxInclusive = 0xFFFFFFFFL;
                this.typeName = "Unsigned Int";
                break;
            }
            case 1016: {
                this.minInclusive = -32767L;
                this.maxInclusive = 32768L;
                this.typeName = "Short";
                break;
            }
            case 1017: {
                this.minInclusive = 0L;
                this.maxInclusive = 65535L;
                this.typeName = "Unsigned Short";
                break;
            }
            case 1004: {
                this.minInclusive = -127L;
                this.maxInclusive = 128L;
                this.typeName = "byte";
                break;
            }
            case 1010: {
                this.minInclusive = 0L;
                this.maxInclusive = Long.MAX_VALUE;
                this.typeName = "Non-negative Integer";
                break;
            }
            case 1008: {
                this.minInclusive = 1L;
                this.maxInclusive = Long.MAX_VALUE;
                this.typeName = "Positive Integer";
                break;
            }
            case 1011: {
                this.minInclusive = -9223372036854775807L;
                this.maxInclusive = 0L;
                this.typeName = "Non-positive Integer";
                break;
            }
            case 1009: {
                this.minInclusive = -9223372036854775807L;
                this.maxInclusive = -1L;
                this.typeName = "Negative Integer";
            }
        }
        this.actualMin = this.minInclusive;
        this.actualMax = this.maxInclusive;
    }

    public Gene createGene(NodeList nodeList) throws CreateGeneException {
        long l = 0L;
        this.reset();
        this.defined = false;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            String string = node.getNodeName();
            if (string.compareTo("minInclusive") == 0) {
                try {
                    l = Long.parseLong(((Element)node).getAttributeNode("value").getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new CreateGeneException("invalid minInclusive value");
                }
                if (this.minInclusive > l || this.maxInclusive < l) {
                    throw new CreateGeneException("invalid minInclusive value: " + l);
                }
                this.actualMin = l;
                bl2 = true;
            }
            if (string.compareTo("maxInclusive") == 0) {
                try {
                    l = Long.parseLong(((Element)node).getAttributeNode("value").getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new CreateGeneException("invalid maxInclusive value");
                }
                if (this.maxInclusive < l || this.minInclusive > l) {
                    throw new CreateGeneException("invalid maxInclusive value: " + l);
                }
                this.actualMax = l;
                bl = true;
            }
            if (string.compareTo("minExclusive") == 0) {
                try {
                    l = Long.parseLong(((Element)node).getAttributeNode("value").getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new CreateGeneException("invalid minExclusive value");
                }
                if (this.minInclusive > l + Long.MIN_VALUE || this.maxInclusive < l + Long.MIN_VALUE) {
                    throw new CreateGeneException("invalid minExclusive value");
                }
                this.actualMin = l + Long.MIN_VALUE;
                bl2 = true;
            }
            if (string.compareTo("maxExclusive") == 0) {
                try {
                    l = Long.parseLong(((Element)node).getAttributeNode("value").getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new CreateGeneException("invalid maxExclusive value");
                }
                if (this.maxInclusive < l - Long.MIN_VALUE || this.minInclusive > l - Long.MIN_VALUE) {
                    throw new CreateGeneException("invalid maxExclusive value: " + l);
                }
                this.actualMax = l - Long.MIN_VALUE;
                bl = true;
            }
            if (string.compareTo("tox-format") == 0) {
                this.format = ((Element)node).getAttributeNode("value").getNodeValue();
            }
            if (string.compareTo("pattern") == 0) {
                this.processPattern(node);
            }
            if (string.compareTo("tox-number") == 0) {
                if (this.defined) {
                    throw new CreateGeneException("invalid " + this.typeName + " simpleType" + " definition!");
                }
                this.defined = true;
                this.gene = this.processPrimitiveType(node);
            }
            if (string.compareTo("tox-value") == 0) {
                if (this.defined) {
                    throw new CreateGeneException("invalid " + this.typeName + " simpleType" + " definition!");
                }
                this.defined = true;
                this.gene = this.processToxValue(node);
            }
            ++n;
        }
        if (!this.defined) {
            if (bl2) {
                if (bl) {
                    this.gene = new ToxNumber(1, this.actualMin, this.actualMax, false, this.format, new ToxUniform(this.actualMin, this.actualMax));
                } else {
                    this.actualMax = this.maxInclusive + this.actualMin;
                    this.gene = new ToxNumber(1, this.actualMin, this.actualMax, false, this.format, new ToxUniform(this.actualMin, this.actualMax));
                }
            } else if (bl) {
                this.actualMin = this.actualMax - this.maxInclusive;
                if (this.actualMin < this.minInclusive) {
                    this.actualMin = this.minInclusive;
                }
                this.gene = new ToxNumber(1, this.actualMin, this.actualMax, false, this.format, new ToxUniform(this.actualMin, this.actualMax));
            } else {
                this.actualMin = this.minInclusive / 2L;
                this.actualMax = this.maxInclusive / 2L;
                this.gene = new ToxNumber(1, this.actualMin, this.actualMax, false, this.format, new ToxUniform(this.actualMin, this.actualMax));
            }
        }
        return this.gene;
    }

    public Gene createGene(Node node) {
        String string = node.getNodeName();
        this.reset();
        if (string.compareTo("tox-number") == 0) {
            return this.processPrimitiveType(node);
        }
        return this.processToxValue(node);
    }

    public Gene createGene() {
        this.reset();
        float f = this.minInclusive / 2L;
        float f2 = this.maxInclusive / 2L;
        return new ToxNumber(1, f, f2, false, this.format, new ToxUniform(f, f2));
    }

    private Gene processPrimitiveType(Node node) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        String string = "";
        String string2 = "";
        String string3 = "";
        ToxRandom toxRandom = null;
        String string4 = ((Element)node).getAttributeNode("sequential").getNodeValue();
        boolean bl = string4.compareTo("yes") == 0;
        try {
            this.format = ((Element)node).getAttributeNode("format").getNodeValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            string = ((Element)node).getAttributeNode("tox-distribution").getNodeValue();
            toxRandom = (ToxRandom)ToXgene.randomGenerators.get(string);
            if (bl) {
                l = this.getMinValue(node);
                l2 = this.getMaxValue(node);
                if (!(toxRandom instanceof ToxConstant)) {
                    ToXgene.error("Invalid sequential tox-number definition: the random generator is not a ToxConstant.");
                }
            } else {
                l = (long)toxRandom.minValue();
                l2 = (long)toxRandom.maxValue();
            }
        }
        catch (KeyNotFoundException keyNotFoundException) {
            ToXgene.error(string + " distribution not defined!", node);
            System.exit(1);
        }
        catch (NullPointerException nullPointerException) {
            l = this.getMinValue(node);
            l2 = this.getMaxValue(node);
            toxRandom = bl ? new ToxConstant(1.0f) : new ToxUniform(l, l2);
        }
        if (l > -9223372036854775807L) {
            if ((float)(l2 - l) == Float.POSITIVE_INFINITY) {
                l2 = Long.MAX_VALUE - l;
            }
        } else if (l2 == Long.MAX_VALUE) {
            l = -4611686018427387903L;
            l2 = 0x3FFFFFFFFFFFFFFFL;
        } else if ((float)(l2 - l) == Float.POSITIVE_INFINITY) {
            l = l2 - Long.MAX_VALUE;
        }
        return new ToxNumber(1, l, l2, bl, this.format, toxRandom);
    }

    private long getMinValue(Node node) {
        String string = "";
        long l = 0L;
        try {
            string = ((Element)node).getAttributeNode("minInclusive").getNodeValue();
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            ToXgene.error("invalid minValue: cannot parse a number from " + string, node);
        }
        catch (NullPointerException nullPointerException) {
            l = this.actualMin;
        }
        return l;
    }

    private long getMaxValue(Node node) {
        String string = "";
        long l = 0L;
        try {
            string = ((Element)node).getAttributeNode("maxInclusive").getNodeValue();
            l = new Long(string);
        }
        catch (NumberFormatException numberFormatException) {
            ToXgene.error("invalid maxValue: cannot parse a number from " + string, node);
        }
        catch (NullPointerException nullPointerException) {
            l = this.actualMax;
        }
        return l;
    }
}

