/*
 * Decompiled with CFR 0.152.
 */
package factories;

import factories.SimpleTypeFactory;
import genes.Gene;
import genes.literals.ToxDate;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import random.ToxRandom;
import random.ToxUniform;
import toxgene.ToXgene;
import util.Date;
import util.DateFormatException;
import util.KeyNotFoundException;

public class DateFactory
extends SimpleTypeFactory {
    private Date minInclusive;
    private Date maxInclusive;
    private String typeName;
    private String format = "";
    private final Date SMALLEST = new Date(0, 1, 1);
    private final Date LARGEST = new Date(3000, 1, 1);

    public DateFactory() {
        this.baseType = "date";
    }

    private void reset() {
        this.minInclusive = this.SMALLEST;
        this.maxInclusive = this.LARGEST;
    }

    public Gene createGene(NodeList nodeList) {
        this.reset();
        this.defined = false;
        boolean bl = false;
        boolean bl2 = false;
        Date date = null;
        Date date2 = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            String string;
            Node node = nodeList.item(n);
            String string2 = node.getNodeName();
            if (string2.compareTo("minInclusive") == 0) {
                string = ((Element)node).getAttributeNode("value").getNodeValue();
                try {
                    date = new Date(string);
                    if (this.minInclusive.after(date)) {
                        ToXgene.error("invalid start date for gene:" + date.toString());
                    }
                    bl = true;
                }
                catch (DateFormatException dateFormatException) {
                    ToXgene.error("cannot parse a date from " + string);
                }
            }
            if (string2.compareTo("maxInclusive") == 0) {
                string = ((Element)node).getAttributeNode("value").getNodeValue();
                try {
                    date2 = new Date(string);
                    if (this.maxInclusive.before(date2)) {
                        ToXgene.error("invalid end date for gene:" + date2.toString());
                    }
                    bl2 = true;
                }
                catch (DateFormatException dateFormatException) {
                    ToXgene.error("cannot parse a date from " + string);
                }
            }
            if (string2.compareTo("minExclusive") == 0) {
                string = ((Element)node).getAttributeNode("value").getNodeValue();
                try {
                    date = new Date(string);
                    date.add(1);
                    if (this.minInclusive.after(date)) {
                        ToXgene.error("invalid start date for gene:" + date.toString());
                    }
                    bl = true;
                }
                catch (DateFormatException dateFormatException) {
                    ToXgene.error("cannot parse a date from " + string);
                }
            }
            if (string2.compareTo("maxExclusive") == 0) {
                string = ((Element)node).getAttributeNode("value").getNodeValue();
                try {
                    date2 = new Date(string);
                    date2.sub(1);
                    if (this.maxInclusive.before(date2)) {
                        ToXgene.error("invalid end date for gene:" + date2.toString());
                    }
                    bl2 = true;
                }
                catch (DateFormatException dateFormatException) {
                    ToXgene.error("cannot parse a date from " + string);
                }
            }
            if (string2.compareTo("tox-format") == 0) {
                this.format = ((Element)node).getAttributeNode("value").getNodeValue();
            }
            if (string2.compareTo("pattern") == 0) {
                this.processPattern(node);
            }
            if (string2.compareTo("tox-date") == 0) {
                if (this.defined) {
                    System.out.println("***** ERROR: Invalid " + this.typeName + " simpleType" + " definition!");
                    System.exit(1);
                }
                this.defined = true;
                this.gene = this.processPrimitiveType(node);
            }
            if (string2.compareTo("tox-value") == 0) {
                if (this.defined) {
                    System.out.println("***** ERROR: Invalid " + this.typeName + " simpleType" + " definition!");
                    System.exit(1);
                }
                this.defined = true;
                this.gene = this.processToxValue(node);
            }
            ++n;
        }
        if (!this.defined) {
            if (!bl) {
                date = this.minInclusive;
            }
            if (!bl2) {
                date2 = this.maxInclusive;
            }
            this.gene = new ToxDate(date, new ToxUniform(0.0f, date2.difference(date)), this.format);
        }
        return this.gene;
    }

    public Gene createGene(Node node) {
        String string = node.getNodeName();
        this.reset();
        if (string.compareTo("tox-date") == 0) {
            return this.processPrimitiveType(node);
        }
        return this.processToxValue(node);
    }

    public Gene createGene() {
        this.reset();
        return new ToxDate(this.minInclusive, new ToxUniform(0.0f, this.minInclusive.difference(this.maxInclusive)), this.format);
    }

    private Gene processPrimitiveType(Node node) {
        String string = "";
        ToxRandom toxRandom = null;
        Date date = null;
        Date date2 = null;
        String string2 = ((Element)node).getAttributeNode("start-date").getNodeValue();
        try {
            date = new Date(string2);
        }
        catch (DateFormatException dateFormatException) {
            ToXgene.error("cannot parse a date from: " + string2);
        }
        string2 = ((Element)node).getAttributeNode("end-date").getNodeValue();
        try {
            date2 = new Date(string2);
        }
        catch (DateFormatException dateFormatException) {
            ToXgene.error("cannot parse a date from: " + string2);
        }
        if (this.minInclusive.after(date) || this.maxInclusive.before(date2)) {
            System.out.println("***** ERROR: invalid dates!!!");
            System.exit(1);
        }
        try {
            this.format = ((Element)node).getAttributeNode("format").getNodeValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            string = ((Element)node).getAttributeNode("tox-distribution").getNodeValue();
            toxRandom = (ToxRandom)ToXgene.randomGenerators.get(string);
        }
        catch (KeyNotFoundException keyNotFoundException) {
            System.out.println("***** ERROR: " + string + " distribution not " + "defined!");
            System.exit(1);
        }
        catch (NullPointerException nullPointerException) {
            toxRandom = new ToxUniform(0.0f, date.difference(date2));
        }
        return new ToxDate(date, toxRandom, this.format);
    }
}

